/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.BaseTemplate;
import com.github.jknack.handlebars.internal.BlockDecorator;
import com.github.jknack.handlebars.internal.VarDecorator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

class TemplateList
extends BaseTemplate
implements Iterable<Template> {
    private final List<Template> nodes = new LinkedList<Template>();
    private final List<BaseTemplate> decorators = new LinkedList<BaseTemplate>();
    private boolean decorate;

    public TemplateList(Handlebars handlebars) {
        super(handlebars);
    }

    public boolean add(Template child) {
        this.nodes.add(child);
        if (child instanceof VarDecorator || child instanceof BlockDecorator) {
            this.decorators.add((BaseTemplate)child);
            this.decorate = true;
        }
        return true;
    }

    @Override
    public void before(Context context, Writer writer) throws IOException {
        for (BaseTemplate node : this.decorators) {
            node.before(context, writer);
        }
    }

    @Override
    public void after(Context context, Writer writer) throws IOException {
        for (BaseTemplate node : this.decorators) {
            node.after(context, writer);
        }
    }

    @Override
    protected void merge(Context context, Writer writer) throws IOException {
        for (Template node : this.nodes) {
            node.apply(context, writer);
        }
    }

    @Override
    public final boolean decorate() {
        return this.decorate;
    }

    @Override
    public String text() {
        StringBuilder buffer = new StringBuilder();
        for (Template node : this.nodes) {
            buffer.append(node.text());
        }
        return buffer.toString();
    }

    @Override
    public Iterator<Template> iterator() {
        return this.nodes.iterator();
    }

    public int size() {
        return this.nodes.size();
    }

    @Override
    public List<String> collect(TagType ... tagType) {
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        for (Template node : this.nodes) {
            tagNames.addAll(node.collect(tagType));
        }
        return new ArrayList<String>(tagNames);
    }

    @Override
    public List<String> collectReferenceParameters() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        for (Template node : this.nodes) {
            paramNames.addAll(node.collectReferenceParameters());
        }
        return new ArrayList<String>(paramNames);
    }

    @Override
    public String toString() {
        return this.nodes.toString();
    }
}

