/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Lambda;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.PathCompiler;
import com.github.jknack.handlebars.PathExpression;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.HelperResolver;
import com.github.jknack.handlebars.internal.Lambdas;
import com.github.jknack.handlebars.internal.ParamType;
import com.github.jknack.handlebars.internal.Transformer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

class Block
extends HelperResolver {
    protected Template body;
    protected final String name;
    private final boolean inverted;
    private final String type;
    private String startDelimiter;
    private String endDelimiter;
    private Template inverse = Template.EMPTY;
    private String inverseLabel;
    private Helper<Object> helper;
    protected final List<String> blockParams;
    protected TagType tagType;
    private List<PathExpression> path;

    public Block(Handlebars handlebars, String name, boolean inverted, String type, List<Object> params, Map<String, Object> hash, List<String> blockParams) {
        super(handlebars);
        this.name = (String)Validate.notNull((Object)name, (String)"The name is required.", (Object[])new Object[0]);
        this.path = PathCompiler.compile(name);
        this.inverted = inverted;
        this.type = type;
        this.params(params);
        this.hash(hash);
        this.blockParams = blockParams;
        this.tagType = TagType.SECTION;
        this.postInit();
    }

    protected void postInit() {
        this.helper = this.helper(this.name);
    }

    @Override
    public void before(Context context, Writer writer) throws IOException {
        if (this.body != null) {
            LinkedList partials = (LinkedList)context.data("__inline_partials_");
            partials.addLast(new HashMap((Map)partials.getLast()));
            this.body.before(context, writer);
        }
    }

    @Override
    public void after(Context context, Writer writer) throws IOException {
        if (this.body != null) {
            LinkedList partials = (LinkedList)context.data("__inline_partials_");
            partials.removeLast();
        }
    }

    @Override
    protected void merge(Context context, Writer writer) throws IOException {
        String helperName;
        Object it;
        if (this.body == null) {
            return;
        }
        Helper<Object> helper = this.helper;
        Template template = this.body;
        Context itCtx = context;
        if (helper == null) {
            Helper<Object> missing;
            it = Transformer.transform(itCtx.get(this.path));
            if (this.inverted) {
                helperName = "unless";
            } else if (it instanceof Iterable) {
                helperName = "each";
            } else if (it instanceof Boolean) {
                helperName = "if";
            } else if (it instanceof Lambda) {
                helperName = "with";
                template = Lambdas.compile(this.handlebars, (Lambda)it, context, template, this.startDelimiter, this.endDelimiter);
            } else {
                helperName = "with";
                itCtx = Context.newContext(context, it);
            }
            helper = this.handlebars.helper(helperName);
            if (it == null && (missing = this.helper("helperMissing")) != null) {
                helper = missing;
            }
        } else {
            helperName = this.name;
            it = Transformer.transform(this.determineContext(context));
        }
        Options options = new Options.Builder(this.handlebars, helperName, this.tagType, itCtx, template).setInverse(this.inverse).setParams(this.params(itCtx)).setHash(this.hash(itCtx)).setBlockParams(this.blockParams).setWriter(writer).build();
        options.data(Context.PARAM_SIZE, this.params.size());
        CharSequence result = helper.apply(it, options);
        if (result != null) {
            writer.append(result);
        }
    }

    public String name() {
        return this.name;
    }

    public boolean inverted() {
        return this.inverted;
    }

    public Block body(Template body) {
        this.body = (Template)Validate.notNull((Object)body, (String)"The template's body is required.", (Object[])new Object[0]);
        return this;
    }

    public Template inverse(String inverseLabel, Template inverse) {
        Validate.notNull((Object)inverseLabel, (String)"The inverseLabel can't be null.", (Object[])new Object[0]);
        Validate.isTrue((inverseLabel.equals("^") || inverseLabel.equals("else") ? 1 : 0) != 0, (String)"The inverseLabel must be one of '^' or 'else'.", (Object[])new Object[0]);
        this.inverseLabel = inverseLabel;
        this.inverse = (Template)Validate.notNull((Object)inverse, (String)"The inverse's template is required.", (Object[])new Object[0]);
        return this;
    }

    public Template inverse() {
        return this.inverse;
    }

    public Block endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Block startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public Template body() {
        return this.body;
    }

    @Override
    public String text() {
        return this.text(true);
    }

    private String text(boolean complete) {
        String hash;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.startDelimiter).append(this.type).append(this.name);
        String params = this.paramsToString(this.params);
        if (params.length() > 0) {
            buffer.append(" ").append(params);
        }
        if ((hash = this.hashToString()).length() > 0) {
            buffer.append(" ").append(hash);
        }
        if (this.blockParams.size() > 0) {
            buffer.append(" as |").append(this.paramsToString(this.blockParams)).append("|");
        }
        buffer.append(this.endDelimiter);
        if (complete) {
            buffer.append(this.body == null ? "" : this.body.text());
            buffer.append(this.inverse == Template.EMPTY ? "" : "{{" + this.inverseLabel + "}}" + this.inverse.text());
        } else {
            buffer.append("\n...\n");
        }
        buffer.append(this.startDelimiter);
        if (this.type.equals("{{")) {
            buffer.append("{{");
        }
        buffer.append('/').append(this.name).append(this.endDelimiter);
        return buffer.toString();
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }

    @Override
    public List<String> collect(TagType ... tagType) {
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        if (this.body != null) {
            tagNames.addAll(this.body.collect(tagType));
        }
        tagNames.addAll(this.inverse.collect(tagType));
        tagNames.addAll(super.collect(tagType));
        return new ArrayList<String>(tagNames);
    }

    @Override
    protected void collect(Collection<String> result, TagType tagType) {
        if (tagType == this.tagType) {
            result.add(this.name);
        }
        super.collect(result, tagType);
    }

    @Override
    public List<String> collectReferenceParameters() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        if (this.body != null) {
            paramNames.addAll(this.body.collectReferenceParameters());
        }
        paramNames.addAll(this.inverse.collectReferenceParameters());
        paramNames.addAll(super.collectReferenceParameters());
        return new ArrayList<String>(paramNames);
    }

    @Override
    protected void collectReferenceParameters(Collection<String> result) {
        for (Object param : this.params) {
            if (!ParamType.REFERENCE.apply(param) || ParamType.STRING.apply(param)) continue;
            result.add((String)param);
        }
        for (Object hashValue : this.hash.values()) {
            if (!ParamType.REFERENCE.apply(hashValue) || ParamType.STRING.apply(hashValue)) continue;
            result.add((String)hashValue);
        }
        super.collectReferenceParameters(result);
    }
}

