/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.PathExpression;
import com.github.jknack.handlebars.internal.path.DataPath;
import com.github.jknack.handlebars.internal.path.IndexedPath;
import com.github.jknack.handlebars.internal.path.ParentPath;
import com.github.jknack.handlebars.internal.path.PropertyPath;
import com.github.jknack.handlebars.internal.path.ResolveParentPath;
import com.github.jknack.handlebars.internal.path.ResolveThisPath;
import com.github.jknack.handlebars.internal.path.ThisPath;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathCompiler {
    private static Map<String, List<PathExpression>> cache = new ConcurrentHashMap<String, List<PathExpression>>();
    private static Pattern pattern = Pattern.compile("((\\[[^\\[\\]]+])|([^" + Pattern.quote("./") + "]+))");

    private PathCompiler() {
    }

    public static List<PathExpression> compile(String key) {
        List<PathExpression> path = cache.get(key);
        if (path == null) {
            path = PathCompiler.parse(key);
            cache.put(key, path);
        }
        return path;
    }

    private static List<PathExpression> parse(String path) {
        LinkedList<PathExpression> resolvers = new LinkedList<PathExpression>();
        if ("this".equals(path) || "./".equals(path) || ".".equals(path)) {
            resolvers.add(new ResolveThisPath(path));
            return resolvers;
        }
        if ("..".equals(path)) {
            resolvers.add(new ResolveParentPath());
            return resolvers;
        }
        if (path.startsWith("../")) {
            resolvers.add(new ParentPath());
            resolvers.addAll(PathCompiler.parse(path.substring("../".length())));
            return resolvers;
        }
        if (path.startsWith("./")) {
            resolvers.add(new ThisPath("./"));
            resolvers.addAll(PathCompiler.parse(path.substring("./".length())));
            return resolvers;
        }
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            String key = matcher.group(1);
            if ("this".equals(key)) {
                resolvers.add(new ThisPath(key));
                continue;
            }
            if (key.charAt(0) == '@') {
                resolvers.add(new DataPath(key));
                continue;
            }
            if (key.charAt(0) == '[' && key.charAt(key.length() - 1) == ']') {
                key = key.substring(1, key.length() - 1);
            }
            try {
                resolvers.add(new IndexedPath(Integer.parseInt(key), key));
            }
            catch (NumberFormatException ex) {
                resolvers.add(new PropertyPath(key));
            }
        }
        return resolvers;
    }
}

