/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Decorator;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsError;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.BaseTemplate;
import com.github.jknack.handlebars.internal.Block;
import com.github.jknack.handlebars.internal.BlockDecorator;
import com.github.jknack.handlebars.internal.ForwardingTemplate;
import com.github.jknack.handlebars.internal.HbsParser;
import com.github.jknack.handlebars.internal.HbsParserBaseVisitor;
import com.github.jknack.handlebars.internal.Partial;
import com.github.jknack.handlebars.internal.TemplateList;
import com.github.jknack.handlebars.internal.Text;
import com.github.jknack.handlebars.internal.VarDecorator;
import com.github.jknack.handlebars.internal.Variable;
import com.github.jknack.handlebars.io.TemplateSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;

abstract class TemplateBuilder<it>
extends HbsParserBaseVisitor<Object> {
    private Handlebars handlebars;
    private TemplateSource source;
    private Boolean hasTag;
    protected StringBuilder line = new StringBuilder();
    private LinkedList<String> qualifier = new LinkedList();
    private int level;

    public TemplateBuilder(Handlebars handlebars, TemplateSource source) {
        this.handlebars = (Handlebars)Validate.notNull((Object)handlebars, (String)"The handlebars can't be null.", (Object[])new Object[0]);
        this.source = (TemplateSource)Validate.notNull((Object)source, (String)"The template source is requied.", (Object[])new Object[0]);
    }

    public Template visit(ParseTree tree) {
        return (Template)super.visit(tree);
    }

    @Override
    public Template visitRawBlock(HbsParser.RawBlockContext ctx) {
        ++this.level;
        HbsParser.SexprContext sexpr = ctx.sexpr();
        Token nameStart = sexpr.QID().getSymbol();
        String name = nameStart.getText();
        this.qualifier.addLast(name);
        String nameEnd = ctx.nameEnd.getText();
        if (!name.equals(nameEnd)) {
            this.reportError(null, ctx.nameEnd.getLine(), ctx.nameEnd.getCharPositionInLine(), String.format("found: '%s', expected: '%s'", nameEnd, name));
        }
        this.hasTag(true);
        Block block = new Block(this.handlebars, name, false, "{{", this.params(sexpr.param()), this.hash(sexpr.hash()), Collections.emptyList());
        block.filename(this.source.filename());
        block.position(nameStart.getLine(), nameStart.getCharPositionInLine());
        String startDelim = ctx.start.getText();
        startDelim = startDelim.substring(0, startDelim.length() - 2);
        block.startDelimiter(startDelim);
        block.endDelimiter(ctx.stop.getText());
        Template body = this.visitBody(ctx.thenBody);
        if (body != null) {
            block.body(body);
        }
        this.hasTag(true);
        this.qualifier.removeLast();
        --this.level;
        return block;
    }

    @Override
    public Template visitBlock(HbsParser.BlockContext ctx) {
        ++this.level;
        HbsParser.SexprContext sexpr = ctx.sexpr();
        boolean decorator = ctx.DECORATOR() != null;
        Token nameStart = sexpr.QID().getSymbol();
        String name = nameStart.getText();
        this.qualifier.addLast(name);
        String nameEnd = ctx.nameEnd.getText();
        if (!name.equals(nameEnd)) {
            this.reportError(null, ctx.nameEnd.getLine(), ctx.nameEnd.getCharPositionInLine(), String.format("found: '%s', expected: '%s'", nameEnd, name));
        }
        this.hasTag(true);
        Block block = decorator ? new BlockDecorator(this.handlebars, name, false, this.params(sexpr.param()), this.hash(sexpr.hash()), this.blockParams(ctx.blockParams()), this.level == 1) : new Block(this.handlebars, name, false, "#", this.params(sexpr.param()), this.hash(sexpr.hash()), this.blockParams(ctx.blockParams()));
        block.filename(this.source.filename());
        block.position(nameStart.getLine(), nameStart.getCharPositionInLine());
        String startDelim = ctx.start.getText();
        startDelim = startDelim.substring(0, startDelim.length() - 1);
        block.startDelimiter(startDelim);
        block.endDelimiter(ctx.stop.getText());
        Template body = this.visitBody(ctx.thenBody);
        if (body != null) {
            block.body(body);
        }
        Block elseroot = block;
        for (HbsParser.ElseBlockContext elseBlock : ctx.elseBlock()) {
            HbsParser.ElseStmtContext elseStmt = elseBlock.elseStmt();
            if (elseStmt != null) {
                Template unless = this.visitBody(elseStmt.unlessBody);
                if (unless == null) continue;
                String inverseLabel = elseStmt.inverseToken.getText();
                if (inverseLabel.startsWith(startDelim)) {
                    inverseLabel = inverseLabel.substring(startDelim.length());
                }
                elseroot.inverse(inverseLabel, unless);
                continue;
            }
            HbsParser.ElseStmtChainContext elseStmtChain = elseBlock.elseStmtChain();
            HbsParser.SexprContext elseexpr = elseStmtChain.sexpr();
            Token elsenameStart = elseexpr.QID().getSymbol();
            String elsename = elsenameStart.getText();
            Block elseblock = new Block(this.handlebars, elsename, false, "#", this.params(elseexpr.param()), this.hash(elseexpr.hash()), this.blockParams(elseStmtChain.blockParams()));
            elseblock.filename(this.source.filename());
            elseblock.position(elsenameStart.getLine(), elsenameStart.getCharPositionInLine());
            elseblock.startDelimiter(startDelim);
            elseblock.endDelimiter(elseBlock.stop.getText());
            Template elsebody = this.visitBody(elseStmtChain.unlessBody);
            elseblock.body(elsebody);
            String inverseLabel = elseStmtChain.inverseToken.getText();
            if (inverseLabel.startsWith(startDelim)) {
                inverseLabel = inverseLabel.substring(startDelim.length());
            }
            elseroot.inverse(inverseLabel, elseblock);
            elseroot = elseblock;
        }
        this.hasTag(true);
        this.qualifier.removeLast();
        --this.level;
        return block;
    }

    @Override
    public Template visitUnless(HbsParser.UnlessContext ctx) {
        ++this.level;
        this.hasTag(true);
        HbsParser.SexprContext sexpr = ctx.sexpr();
        Token nameStart = sexpr.QID().getSymbol();
        String name = nameStart.getText();
        this.qualifier.addLast(name);
        String nameEnd = ctx.nameEnd.getText();
        if (!name.equals(nameEnd)) {
            this.reportError(null, ctx.nameEnd.getLine(), ctx.nameEnd.getCharPositionInLine(), String.format("found: '%s', expected: '%s'", nameEnd, name));
        }
        Block block = new Block(this.handlebars, name, true, "^", Collections.emptyList(), Collections.emptyMap(), this.blockParams(ctx.blockParams()));
        block.filename(this.source.filename());
        block.position(nameStart.getLine(), nameStart.getCharPositionInLine());
        String startDelim = ctx.start.getText();
        block.startDelimiter(startDelim.substring(0, startDelim.length() - 1));
        block.endDelimiter(ctx.stop.getText());
        Template body = this.visitBody(ctx.body());
        if (body != null) {
            block.body(body);
        }
        this.hasTag(true);
        --this.level;
        return block;
    }

    @Override
    public Template visitVar(HbsParser.VarContext ctx) {
        this.hasTag(false);
        HbsParser.SexprContext sexpr = ctx.sexpr();
        return this.newVar(sexpr.QID().getSymbol(), TagType.VAR, this.params(sexpr.param()), this.hash(sexpr.hash()), ctx.start.getText(), ctx.stop.getText(), ctx.DECORATOR() != null);
    }

    @Override
    public Object visitEscape(HbsParser.EscapeContext ctx) {
        Token token = ctx.ESC_VAR().getSymbol();
        String text = token.getText().substring(1);
        this.line.append(text);
        return new Text(this.handlebars, text, "\\").filename(this.source.filename()).position(token.getLine(), token.getCharPositionInLine());
    }

    @Override
    public Template visitTvar(HbsParser.TvarContext ctx) {
        this.hasTag(false);
        HbsParser.SexprContext sexpr = ctx.sexpr();
        return this.newVar(sexpr.QID().getSymbol(), TagType.TRIPLE_VAR, this.params(sexpr.param()), this.hash(sexpr.hash()), ctx.start.getText(), ctx.stop.getText(), false);
    }

    @Override
    public Template visitAmpvar(HbsParser.AmpvarContext ctx) {
        this.hasTag(false);
        HbsParser.SexprContext sexpr = ctx.sexpr();
        return this.newVar(sexpr.QID().getSymbol(), TagType.AMP_VAR, this.params(sexpr.param()), this.hash(sexpr.hash()), ctx.start.getText(), ctx.stop.getText(), false);
    }

    private Template newVar(Token name, TagType varType, List<Object> params, Map<String, Object> hash, String startDelimiter, String endDelimiter, boolean decorator) {
        String[] parts;
        boolean isHelper;
        String varName = name.getText();
        boolean bl = isHelper = params.size() > 0 || hash.size() > 0 || varType == TagType.SUB_EXPRESSION;
        if (!isHelper && this.qualifier.size() > 0 && "with".equals(this.qualifier.getLast()) && !varName.startsWith(".")) {
            varName = "this." + varName;
        }
        if ((parts = varName.split("\\./")).length > 0 && NumberUtils.isNumber((String)parts[parts.length - 1]) && !varName.endsWith(".")) {
            String evidence = varName;
            String reason = "found: " + varName + ", expecting: " + varName + ".";
            String message = this.source.filename() + ":" + name.getLine() + ":" + name.getChannel() + ": " + reason + "\n";
            throw new HandlebarsException(new HandlebarsError(this.source.filename(), name.getLine(), name.getCharPositionInLine(), reason, evidence, message));
        }
        if (decorator) {
            Decorator dec = this.handlebars.decorator(varName);
            if (dec == null) {
                this.reportError(null, name.getLine(), name.getCharPositionInLine(), "could not find decorator: '" + varName + "'");
            }
        } else {
            Helper helperMissing;
            Helper helper = this.handlebars.helper(varName);
            if (helper == null && isHelper && (helperMissing = this.handlebars.helper("helperMissing")) == null) {
                this.reportError(null, name.getLine(), name.getCharPositionInLine(), "could not find helper: '" + varName + "'");
            }
        }
        Variable var = decorator ? new VarDecorator(this.handlebars, varName, TagType.STAR_VAR, params, hash, this.level == 0) : new Variable(this.handlebars, varName, varType, params, hash);
        return var.startDelimiter(startDelimiter).endDelimiter(endDelimiter).filename(this.source.filename()).position(name.getLine(), name.getCharPositionInLine());
    }

    private Map<String, Object> hash(List<HbsParser.HashContext> ctx) {
        if (ctx == null || ctx.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (HbsParser.HashContext hc : ctx) {
            result.put(hc.QID().getText(), super.visit((ParseTree)hc.param()));
        }
        return result;
    }

    private List<String> blockParams(HbsParser.BlockParamsContext ctx) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        List<TerminalNode> ids = ctx.QID();
        if (ids == null || ids.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (TerminalNode id : ids) {
            result.add(id.getText());
        }
        return result;
    }

    private List<Object> params(List<HbsParser.ParamContext> params) {
        if (params == null || params.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (HbsParser.ParamContext param : params) {
            result.add(super.visit((ParseTree)param));
        }
        return result;
    }

    @Override
    public Object visitBoolParam(HbsParser.BoolParamContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitSubParamExpr(HbsParser.SubParamExprContext ctx) {
        HbsParser.SexprContext sexpr = ctx.sexpr();
        return this.newVar(sexpr.QID().getSymbol(), TagType.SUB_EXPRESSION, this.params(sexpr.param()), this.hash(sexpr.hash()), ctx.start.getText(), ctx.stop.getText(), false);
    }

    @Override
    public Object visitStringParam(HbsParser.StringParamContext ctx) {
        return this.stringLiteral((RuleContext)ctx);
    }

    @Override
    public Object visitCharParam(HbsParser.CharParamContext ctx) {
        return this.charLiteral((RuleContext)ctx);
    }

    private String charLiteral(RuleContext ctx) {
        return ctx.getText().replace("\\'", "'");
    }

    private String stringLiteral(RuleContext ctx) {
        return ctx.getText().replace("\\\"", "\"");
    }

    @Override
    public Object visitRefParam(HbsParser.RefParamContext ctx) {
        return ctx.getText();
    }

    @Override
    public Object visitIntParam(HbsParser.IntParamContext ctx) {
        return Integer.parseInt(ctx.getText());
    }

    @Override
    public Template visitTemplate(HbsParser.TemplateContext ctx) {
        Template template = this.visitBody(ctx.body());
        if (!this.handlebars.infiniteLoops() && template instanceof BaseTemplate) {
            template = TemplateBuilder.infiniteLoop(this.source, (BaseTemplate)template);
        }
        this.destroy();
        return template;
    }

    private static Template infiniteLoop(final TemplateSource source, BaseTemplate template) {
        return new ForwardingTemplate(template){

            @Override
            protected void beforeApply(Context context) {
                LinkedList invocationStack = (LinkedList)context.data(Context.INVOCATION_STACK);
                invocationStack.addLast(source);
            }

            @Override
            protected void afterApply(Context context) {
                LinkedList invocationStack = (LinkedList)context.data(Context.INVOCATION_STACK);
                if (!invocationStack.isEmpty()) {
                    invocationStack.removeLast();
                }
            }
        };
    }

    @Override
    public Template visitPartial(HbsParser.PartialContext ctx) {
        this.hasTag(true);
        String indent = this.line.toString();
        if (this.hasTag()) {
            if (StringUtils.isEmpty((CharSequence)indent) || !StringUtils.isEmpty((CharSequence)indent.trim())) {
                indent = null;
            }
        } else {
            indent = null;
        }
        PartialInfo info = (PartialInfo)super.visit((ParseTree)ctx.pexpr());
        String startDelim = ctx.start.getText();
        BaseTemplate partial = new Partial(this.handlebars, info.path, info.context, info.hash).startDelimiter(startDelim.substring(0, startDelim.length() - 1)).endDelimiter(ctx.stop.getText()).indent(indent).filename(this.source.filename()).position(info.token.getLine(), info.token.getCharPositionInLine());
        return partial;
    }

    @Override
    public Object visitPartialBlock(HbsParser.PartialBlockContext ctx) {
        this.hasTag(true);
        String indent = this.line.toString();
        if (this.hasTag()) {
            if (StringUtils.isEmpty((CharSequence)indent) || !StringUtils.isEmpty((CharSequence)indent.trim())) {
                indent = null;
            }
        } else {
            indent = null;
        }
        PartialInfo info = (PartialInfo)super.visit((ParseTree)ctx.pexpr());
        Template fn = this.visitBody(ctx.thenBody);
        String startDelim = ctx.start.getText();
        BaseTemplate partial = new Partial(this.handlebars, info.path, info.context, info.hash).setPartial(fn).startDelimiter(startDelim.substring(0, startDelim.length() - 1)).endDelimiter(ctx.stop.getText()).indent(indent).filename(this.source.filename()).position(info.token.getLine(), info.token.getCharPositionInLine());
        return partial;
    }

    @Override
    public PartialInfo visitStaticPath(HbsParser.StaticPathContext ctx) {
        Token pathToken = ctx.path;
        String uri = pathToken.getText();
        if (uri.startsWith("[") && uri.endsWith("]")) {
            uri = uri.substring(1, uri.length() - 1);
        }
        if (uri.startsWith("/")) {
            String message = "found: '/', partial shouldn't start with '/'";
            this.reportError(null, pathToken.getLine(), pathToken.getCharPositionInLine(), message);
        }
        TerminalNode partialContext = ctx.QID(1);
        PartialInfo partial = new PartialInfo();
        partial.token = pathToken;
        partial.path = new Text(this.handlebars, uri);
        partial.hash = this.hash(ctx.hash());
        partial.context = partialContext != null ? partialContext.getText() : null;
        return partial;
    }

    @Override
    public PartialInfo visitDynamicPath(HbsParser.DynamicPathContext ctx) {
        HbsParser.SexprContext sexpr = ctx.sexpr();
        TerminalNode qid = sexpr.QID();
        Template expression = this.newVar(qid.getSymbol(), TagType.SUB_EXPRESSION, this.params(sexpr.param()), this.hash(sexpr.hash()), ctx.start.getText(), ctx.stop.getText(), false);
        PartialInfo partial = new PartialInfo();
        partial.path = expression;
        partial.hash = this.hash(ctx.hash());
        partial.context = null;
        partial.token = qid.getSymbol();
        return partial;
    }

    @Override
    public Template visitBody(HbsParser.BodyContext ctx) {
        List<HbsParser.StatementContext> stats = ctx.statement();
        if (stats.size() == 0 || stats.size() == 1 && stats.get(0) == Template.EMPTY) {
            return Template.EMPTY;
        }
        TemplateList list = new TemplateList(this.handlebars);
        list.filename(this.source.filename());
        Template prev = null;
        boolean setMd = false;
        for (HbsParser.StatementContext statement : stats) {
            Template candidate = this.visit((ParseTree)statement);
            if (candidate == null) continue;
            if (!setMd) {
                list.filename(candidate.filename()).position(candidate.position()[0], candidate.position()[1]);
                setMd = true;
            }
            if (candidate instanceof Text) {
                if (!(prev instanceof Text)) {
                    list.add(candidate);
                    prev = candidate;
                    continue;
                }
                ((Text)prev).append(((Text)candidate).textWithoutEscapeChar());
                continue;
            }
            list.add(candidate);
            prev = candidate;
        }
        return list;
    }

    @Override
    public Object visitComment(HbsParser.CommentContext ctx) {
        return Template.EMPTY;
    }

    @Override
    public Template visitStatement(HbsParser.StatementContext ctx) {
        return this.visit(ctx.getChild(0));
    }

    @Override
    public Template visitText(HbsParser.TextContext ctx) {
        String text = ctx.getText();
        this.line.append(text);
        return new Text(this.handlebars, text).filename(this.source.filename()).position(ctx.start.getLine(), ctx.start.getCharPositionInLine());
    }

    @Override
    public Template visitSpaces(HbsParser.SpacesContext ctx) {
        Token space = ctx.SPACE().getSymbol();
        String text = space.getText();
        this.line.append(text);
        if (space.getChannel() == 1) {
            return null;
        }
        return new Text(this.handlebars, text).filename(this.source.filename()).position(ctx.start.getLine(), ctx.start.getCharPositionInLine());
    }

    @Override
    public BaseTemplate visitNewline(HbsParser.NewlineContext ctx) {
        Token newline = ctx.NL().getSymbol();
        this.line.setLength(0);
        this.hasTag = null;
        if (newline.getChannel() == 1) {
            return null;
        }
        return new Text(this.handlebars, newline.getText()).filename(this.source.filename()).position(newline.getLine(), newline.getCharPositionInLine());
    }

    private boolean hasTag() {
        if (this.handlebars.prettyPrint()) {
            return this.hasTag == null ? false : this.hasTag;
        }
        return false;
    }

    private void hasTag(boolean hasTag) {
        if (this.hasTag != Boolean.FALSE) {
            this.hasTag = hasTag;
        }
    }

    private void destroy() {
        this.handlebars = null;
        this.source = null;
        this.hasTag = null;
        this.line.delete(0, this.line.length());
        this.line = null;
    }

    protected void reportError(CommonToken offendingToken, String message) {
        this.reportError(offendingToken, offendingToken.getLine(), offendingToken.getCharPositionInLine(), message);
    }

    protected abstract void reportError(CommonToken var1, int var2, int var3, String var4);

    private static class PartialInfo {
        private Token token;
        private Map<String, Object> hash;
        private Template path;
        private String context;

        private PartialInfo() {
        }
    }
}

