/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;

public class MethodHelper
implements Helper<Object> {
    private Object source;
    private Method method;

    public MethodHelper(Method method, Object source) {
        this.method = (Method)Validate.notNull((Object)method, (String)"A helper method is required.", (Object[])new Object[0]);
        this.source = source;
    }

    @Override
    public CharSequence apply(Object context, Options options) throws IOException {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        if (args.length > 0) {
            if (args.length == 1) {
                args[0] = paramTypes[0] == Options.class ? options : context;
            } else {
                args[0] = context;
                for (int i = 0; i < options.params.length; ++i) {
                    args[i + 1] = options.param(i);
                }
                if (args.length > options.params.length + 1) {
                    args[args.length - 1] = options;
                }
            }
        }
        try {
            return (CharSequence)this.method.invoke(this.source, args);
        }
        catch (InvocationTargetException ex) {
            throw this.launderThrowable(ex.getCause());
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("could not execute helper: " + this.method.getName(), ex);
        }
    }

    private RuntimeException launderThrowable(Throwable cause) throws IOException {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        return new IllegalStateException("could not execute helper: " + this.method.getName(), cause);
    }
}

