/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.helper.MethodHelper;
import com.github.jknack.handlebars.internal.Files;
import com.github.jknack.handlebars.js.HandlebarsJs;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class DefaultHelperRegistry
implements HelperRegistry {
    private final Map<String, Helper<?>> helpers = new HashMap();
    private HandlebarsJs handlebarsJs = HandlebarsJs.create(this);

    @Override
    public <C> Helper<C> helper(String name) {
        Validate.notEmpty((CharSequence)name, (String)"A helper's name is required.", (Object[])new Object[0]);
        return this.helpers.get(name);
    }

    @Override
    public <H> HelperRegistry registerHelper(String name, Helper<H> helper) {
        Validate.notEmpty((CharSequence)name, (String)"A helper's name is required.", (Object[])new Object[0]);
        Validate.notNull(helper, (String)"A helper is required.", (Object[])new Object[0]);
        Helper<H> oldHelper = this.helpers.put(name, helper);
        if (oldHelper != null) {
            Handlebars.warn("Helper '%s' has been replaced by '%s'", name, helper);
        }
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(Object helperSource) {
        Validate.notNull((Object)helperSource, (String)"The helper source is required.", (Object[])new Object[0]);
        Validate.isTrue((!(helperSource instanceof String) ? 1 : 0) != 0, (String)"java.lang.String isn't a helper source.", (Object[])new Object[0]);
        try {
            if (helperSource instanceof File) {
                return this.registerHelpers((File)helperSource);
            }
            if (helperSource instanceof URI) {
                return this.registerHelpers((URI)helperSource);
            }
            if (helperSource instanceof Class) {
                return this.registerHelpers((Class)helperSource);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't register helpres", ex);
        }
        this.registerDynamicHelper(helperSource, helperSource.getClass());
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(Class<?> helperSource) {
        Validate.notNull(helperSource, (String)"The helper source is required.", (Object[])new Object[0]);
        if (Enum.class.isAssignableFrom(helperSource)) {
            Enum[] helpers;
            for (Enum helper : helpers = (Enum[])helperSource.getEnumConstants()) {
                Validate.isTrue((boolean)(helper instanceof Helper), (String)"'%s' isn't a helper.", (Object[])new Object[]{helper.name()});
                this.registerHelper(helper.name(), (Helper)((Object)helper));
            }
        } else {
            this.registerDynamicHelper(null, helperSource);
        }
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(URI location) throws Exception {
        return this.registerHelpers(location.getPath(), Files.read(location.toString()));
    }

    @Override
    public HelperRegistry registerHelpers(File input) throws Exception {
        return this.registerHelpers(input.getAbsolutePath(), Files.read(input));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, Reader source) throws Exception {
        return this.registerHelpers(filename, Files.read(source));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, InputStream source) throws Exception {
        return this.registerHelpers(filename, Files.read(source));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, String source) throws Exception {
        Validate.notNull((Object)filename, (String)"The filename is required.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)source, (String)"The source is required.", (Object[])new Object[0]);
        this.handlebarsJs.registerHelpers(filename, source);
        return this;
    }

    @Override
    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.helpers.entrySet();
    }

    private void registerDynamicHelper(Object source, Class<?> clazz) {
        int size = this.helpers.size();
        int replaced = 0;
        if (clazz != Object.class) {
            Method[] methods;
            HashSet<String> overloaded = new HashSet<String>();
            for (Method method : methods = clazz.getDeclaredMethods()) {
                boolean isPublic = Modifier.isPublic(method.getModifiers());
                String helperName = method.getName();
                if (!isPublic || !CharSequence.class.isAssignableFrom(method.getReturnType())) continue;
                boolean isStatic = Modifier.isStatic(method.getModifiers());
                if (source == null && !isStatic) continue;
                if (this.helpers.containsKey(helperName)) {
                    ++replaced;
                }
                Validate.isTrue((boolean)overloaded.add(helperName), (String)("name conflict found: " + helperName), (Object[])new Object[0]);
                this.registerHelper(helperName, new MethodHelper(method, source));
            }
        }
        Validate.isTrue((size + replaced != this.helpers.size() ? 1 : 0) != 0, (String)("No helper method was found in: " + clazz.getName()), (Object[])new Object[0]);
    }
}

