/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.Validate;

public class ServletContextTemplateLoader
extends TemplateLoader {
    private final ServletContext servletContext;

    public ServletContextTemplateLoader(ServletContext servletContext, String prefix, String suffix) {
        this.setPrefix(prefix);
        this.setSuffix(suffix);
        this.servletContext = (ServletContext)Validate.notNull((Object)servletContext, (String)"The servlet context is required.", (Object[])new Object[0]);
    }

    public ServletContextTemplateLoader(ServletContext servletContext, String prefix) {
        this(servletContext, prefix, ".hbs");
    }

    public ServletContextTemplateLoader(ServletContext servletContext) {
        this(servletContext, "/", ".hbs");
    }

    @Override
    protected Reader read(String path) throws IOException {
        InputStream input = this.servletContext.getResourceAsStream(path);
        if (input == null) {
            return null;
        }
        return new InputStreamReader(input, "UTF-8");
    }
}

