/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.BaseTemplate;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

class Partial
extends BaseTemplate {
    private Template template;
    private String path;
    private String switchContext;
    private String startDelimiter;
    private String endDelimiter;

    Partial() {
    }

    public Partial template(String path, Template template, String context) {
        this.path = (String)Validate.notEmpty((CharSequence)path, (String)"The path is required.", (Object[])new Object[0]);
        this.template = (Template)Validate.notNull((Object)template, (String)"The template is required.", (Object[])new Object[0]);
        this.switchContext = StringUtils.defaultString((String)context, (String)"this");
        return this;
    }

    @Override
    public void merge(Context current, Writer writer) throws IOException {
        if (this.switchContext.equals("this")) {
            this.template.apply(current, writer);
        } else {
            this.template.apply(current.get(this.switchContext), writer);
        }
    }

    @Override
    public String text() {
        return this.startDelimiter + '>' + this.path + this.endDelimiter;
    }

    public Partial endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Partial startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }
}

