/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.springmvc;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class HandlebarsView
extends AbstractTemplateView {
    protected Template template;
    protected ValueResolver[] valueResolvers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Context context = Context.newBuilder(model).resolver(this.valueResolvers).build();
        try {
            this.template.apply(context, (Writer)response.getWriter());
        }
        finally {
            context.destroy();
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public boolean checkResource(Locale locale) {
        return this.template != null;
    }

    public void setTemplate(Template template) {
        this.template = Objects.requireNonNull(template, "A handlebars template is required.");
    }

    public void setValueResolver(ValueResolver ... valueResolvers) {
        this.valueResolvers = Objects.requireNonNull(valueResolvers, "At least one value-resolver must be present.");
    }

    protected boolean isContextRequired() {
        return false;
    }
}

