/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.maven;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.PrecompileHelper;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="precompile", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class HandlebarsPlugin
extends AbstractMojo {
    @Parameter(required=true)
    private String output;
    @Parameter
    private boolean includeRuntime;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    private String prefix;
    @Parameter(defaultValue=".hbs")
    private String suffix;
    @Parameter
    private boolean minimize;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File basedir = new File(this.prefix);
        FileTemplateLoader loader = new FileTemplateLoader(basedir, this.suffix);
        Handlebars handlebars = new Handlebars((TemplateLoader)loader);
        File output = new File(this.output);
        PrintWriter writer = null;
        boolean error = true;
        InputStream runtimeIS = ((Object)((Object)this)).getClass().getResourceAsStream("/handlebars.runtime.js");
        try {
            writer = new PrintWriter(output);
            if (this.includeRuntime) {
                IOUtil.copy((InputStream)runtimeIS, (Writer)writer);
            }
            List files = FileUtils.getFiles((File)basedir, (String)("/**/*" + this.suffix), null);
            this.getLog().info((CharSequence)"Compiling templates...");
            this.getLog().debug((CharSequence)"Options:");
            this.getLog().debug((CharSequence)("  output: " + output));
            this.getLog().debug((CharSequence)("  prefix: " + this.prefix));
            this.getLog().debug((CharSequence)("  suffix: " + this.suffix));
            this.getLog().debug((CharSequence)("  minimize: " + this.minimize));
            this.getLog().debug((CharSequence)("  includeRuntime: " + this.includeRuntime));
            Context nullContext = Context.newContext(null);
            for (File file : files) {
                String templateName = file.getPath().replace(this.prefix, "").replace(this.suffix, "");
                if (templateName.startsWith("/")) {
                    templateName = templateName.substring(1);
                }
                this.getLog().debug((CharSequence)("compiling: " + templateName));
                Template template = handlebars.compileInline("{{precompile \"" + templateName + "\"}}");
                Options opts = new Options.Builder(handlebars, TagType.VAR, nullContext, template).build();
                writer.append("// Source: ").append(file.getPath()).append("\n");
                writer.append(PrecompileHelper.INSTANCE.apply((Object)templateName, opts)).append("\n\n");
            }
            writer.flush();
            IOUtil.close((Writer)writer);
            if (this.minimize) {
                this.minimize(output);
            }
            if (files.size() > 0) {
                this.getLog().info((CharSequence)("  templates were saved in: " + output));
                error = false;
            } else {
                this.getLog().warn((CharSequence)"  no templates were found");
            }
        }
        catch (IOException ex) {
            throw new MojoFailureException("Can't scan directory " + basedir, (Throwable)ex);
        }
        finally {
            IOUtil.close((InputStream)runtimeIS);
            IOUtil.close((Writer)writer);
            if (error) {
                output.delete();
            }
        }
    }

    private void minimize(File output) throws IOException, MojoFailureException {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        options.setOutputCharset("UTF-8");
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        compiler.initOptions(options);
        Result result = compiler.compile(Collections.emptyList(), Arrays.asList(SourceFile.fromFile((File)output)), options);
        if (!result.success) {
            JSError[] errors = result.errors;
            throw new MojoFailureException(errors[0].toString());
        }
        FileUtils.fileWrite((File)output, (String)compiler.toSource());
    }
}

