/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.cache;

import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.io.ReloadableTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class GuavaTemplateCache
implements TemplateCache {
    private final Cache<TemplateSource, Template> cache;
    private boolean reload;

    public GuavaTemplateCache(Cache<TemplateSource, Template> cache) {
        this.cache = Objects.requireNonNull(cache, "The cache is required.");
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public void evict(TemplateSource source) {
        this.cache.invalidate((Object)this.key(source));
    }

    public Template get(TemplateSource source, Parser parser) throws IOException {
        Objects.requireNonNull(source, "The source is required.");
        Objects.requireNonNull(parser, "The parser is required.");
        try {
            return (Template)this.cache.get((Object)this.key(source), () -> parser.parse(source));
        }
        catch (ExecutionException ex) {
            throw this.launderThrowable(source, ex.getCause());
        }
    }

    public GuavaTemplateCache setReload(boolean reload) {
        this.reload = reload;
        return this;
    }

    private RuntimeException launderThrowable(TemplateSource source, Throwable cause) {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        return new HandlebarsException("Can't parse: " + source, cause);
    }

    private TemplateSource key(TemplateSource source) {
        return this.reload ? new ReloadableTemplateSource(source) : source;
    }
}

