/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    protected int m_amountOfBytesReadable;

    public LimitedInputStream(InputStream in, int limit) {
        super(in);
        this.m_amountOfBytesReadable = limit;
    }

    public int available() throws IOException {
        int result;
        if (this.m_amountOfBytesReadable == 0) {
            result = 0;
        } else {
            result = super.available();
            if (this.m_amountOfBytesReadable < result) {
                result = this.m_amountOfBytesReadable;
            }
        }
        return result;
    }

    public int read() throws IOException {
        int result;
        if (this.m_amountOfBytesReadable == 0) {
            result = -1;
        } else {
            result = super.read();
            if (result >= 0) {
                --this.m_amountOfBytesReadable;
            }
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        int bytesToRead = len;
        if (this.m_amountOfBytesReadable == 0) {
            result = -1;
        } else {
            if (this.m_amountOfBytesReadable < len) {
                bytesToRead = this.m_amountOfBytesReadable;
            }
            if ((result = super.read(b, off, bytesToRead)) > 0) {
                this.m_amountOfBytesReadable -= result;
            }
        }
        return result;
    }

    public long skip(long howManyBytes) throws IOException {
        long result;
        long bytesToSkip = howManyBytes;
        if (this.m_amountOfBytesReadable == 0) {
            result = 0L;
        } else {
            if ((long)this.m_amountOfBytesReadable < howManyBytes) {
                bytesToSkip = this.m_amountOfBytesReadable;
            }
            result = super.skip(howManyBytes);
            this.m_amountOfBytesReadable = (int)((long)this.m_amountOfBytesReadable - result);
        }
        return result;
    }
}

