/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.io;

import info.monitorenter.cpdetector.io.ByteOrderMarkDetector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.junit.Assert;
import org.junit.Test;

public class ByteOrderMarkDetectorTest {
    @Test
    public void ucs4bigendian() throws IOException {
        String charsetName = "UCS-4BE";
        try {
            Charset expected = Charset.forName("UCS-4BE");
            byte[] barr = new byte[]{0, 0, -1, -1};
            ByteArrayInputStream in = new ByteArrayInputStream(barr);
            ByteOrderMarkDetector byteOrderMarkDetector = new ByteOrderMarkDetector();
            Charset result = byteOrderMarkDetector.detectCodepage(in, 4);
            Assert.assertEquals((Object)expected, (Object)result);
        }
        catch (UnsupportedCharsetException ucse) {
            Assert.fail((String)("This test cannot be run on this machine. Charset is missing: " + ucse.getMessage()));
        }
    }

    @Test
    public void ucs4littleendian() throws IOException {
        String charsetName = "UCS-4LE";
        try {
            Charset expected = Charset.forName("UCS-4LE");
            byte[] barr = new byte[]{-1, -2, 0, 0};
            ByteArrayInputStream in = new ByteArrayInputStream(barr);
            ByteOrderMarkDetector byteOrderMarkDetector = new ByteOrderMarkDetector();
            Charset result = byteOrderMarkDetector.detectCodepage(in, 4);
            Assert.assertEquals((Object)expected, (Object)result);
        }
        catch (UnsupportedCharsetException ucse) {
            Assert.fail((String)("This test cannot be run on this machine. Charset is missing: " + ucse.getMessage()));
        }
    }

    @Test
    public void ucs4_2143order() throws IOException {
        String charsetName = "UCS-4";
        try {
            Charset expected = Charset.forName("UCS-4");
            byte[] barr = new byte[]{0, 0, -1, -2};
            ByteArrayInputStream in = new ByteArrayInputStream(barr);
            ByteOrderMarkDetector byteOrderMarkDetector = new ByteOrderMarkDetector();
            Charset result = byteOrderMarkDetector.detectCodepage(in, 4);
            Assert.assertEquals((Object)expected, (Object)result);
        }
        catch (UnsupportedCharsetException ucse) {
            Assert.fail((String)("This test cannot be run on this machine. Charset is missing: " + ucse.getMessage()));
        }
    }

    @Test
    public void ucs4_3412order() throws IOException {
        String charsetName = "UCS-4";
        try {
            Charset expected = Charset.forName("UCS-4");
            byte[] barr = new byte[]{-2, -1, 0, 0};
            ByteArrayInputStream in = new ByteArrayInputStream(barr);
            ByteOrderMarkDetector byteOrderMarkDetector = new ByteOrderMarkDetector();
            Charset result = byteOrderMarkDetector.detectCodepage(in, 4);
            Assert.assertEquals((Object)expected, (Object)result);
        }
        catch (UnsupportedCharsetException ucse) {
            Assert.fail((String)("This test cannot be run on this machine. Charset is missing: " + ucse.getMessage()));
        }
    }

    @Test
    public void utf16bigendian() throws IOException {
        String charsetName = "UTF-16BE";
        try {
            Charset expected = Charset.forName("UTF-16BE");
            byte[] barr = new byte[]{-2, -1, 0, 1};
            ByteArrayInputStream in = new ByteArrayInputStream(barr);
            ByteOrderMarkDetector byteOrderMarkDetector = new ByteOrderMarkDetector();
            Charset result = byteOrderMarkDetector.detectCodepage(in, 4);
            Assert.assertEquals((Object)expected, (Object)result);
        }
        catch (UnsupportedCharsetException ucse) {
            Assert.fail((String)("This test cannot be run on this machine. Charset is missing: " + ucse.getMessage()));
        }
    }

    @Test
    public void utf16littleendian() throws IOException {
        String charsetName = "UTF-16LE";
        try {
            Charset expected = Charset.forName("UTF-16LE");
            byte[] barr = new byte[]{-1, -2, 0, 1};
            ByteArrayInputStream in = new ByteArrayInputStream(barr);
            ByteOrderMarkDetector byteOrderMarkDetector = new ByteOrderMarkDetector();
            Charset result = byteOrderMarkDetector.detectCodepage(in, 4);
            Assert.assertEquals((Object)expected, (Object)result);
        }
        catch (UnsupportedCharsetException ucse) {
            Assert.fail((String)("This test cannot be run on this machine. Charset is missing: " + ucse.getMessage()));
        }
    }

    @Test
    public void utf8() throws IOException {
        String charsetName = "UTF-8";
        try {
            Charset expected = Charset.forName("UTF-8");
            byte[] barr = new byte[]{-17, -69, -65, 0};
            ByteArrayInputStream in = new ByteArrayInputStream(barr);
            ByteOrderMarkDetector byteOrderMarkDetector = new ByteOrderMarkDetector();
            Charset result = byteOrderMarkDetector.detectCodepage(in, 4);
            Assert.assertEquals((Object)expected, (Object)result);
        }
        catch (UnsupportedCharsetException ucse) {
            Assert.fail((String)("This test cannot be run on this machine. Charset is missing: " + ucse.getMessage()));
        }
    }
}

