package file.contract;

import java.util.Properties;

import loader.PropertiesLoader;
import verifier.StringVerifier;


public abstract class AbstractFileManager implements FileManager {
	private static final long serialVersionUID = 1913508232000906599L;

	private String propertieKey;
	private String repositoryPath = "";

	
	public AbstractFileManager(String propertieKey) {

		this.propertieKey = propertieKey;
	}

	protected String getRepositoryPath() {

		if (StringVerifier.isBlanck(this.repositoryPath)) {

			PropertiesLoader loader = new PropertiesLoader();
			Properties properties = loader.getPropertiesFile(PropertiesDefault.DEFAULT_PROPERTIES);
			
			loader.verifyIfValueExists(properties, this.propertieKey);
					
			this.repositoryPath = loader.getProperty(properties, this.propertieKey);
		}

		return this.repositoryPath;
	}

}