/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.odselement.ManifestElement;
import com.github.jferard.fastods.odselement.OdsEntry;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import com.github.jferard.fastods.util.ZipUTF8WriterBuilderImpl;
import java.io.IOException;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUTF8WriterImpl
implements ZipUTF8Writer {
    private final ZipOutputStream zipStream;
    private final Writer writer;
    private final ManifestElement manifestElement;
    private final XMLUtil xmlUtil;

    public static ZipUTF8WriterBuilderImpl builder() {
        return new ZipUTF8WriterBuilderImpl();
    }

    ZipUTF8WriterImpl(XMLUtil xmlUtil, ZipOutputStream zipStream, Writer writer, ManifestElement manifestElement) {
        this.zipStream = zipStream;
        this.writer = writer;
        this.manifestElement = manifestElement;
        this.xmlUtil = xmlUtil;
    }

    @Override
    public Appendable append(char c) throws IOException {
        return this.writer.append(c);
    }

    @Override
    public Appendable append(CharSequence arg0) throws IOException {
        return this.writer.append(arg0);
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.writer.append(csq, start, end);
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.zipStream.close();
    }

    @Override
    public void closeEntry() throws IOException {
        this.writer.flush();
        this.zipStream.closeEntry();
    }

    @Override
    public void finish() throws IOException {
        this.manifestElement.write(this.xmlUtil, this);
        this.zipStream.finish();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void putAndRegisterNextEntry(OdsEntry entry) throws IOException {
        this.registerEntry(entry);
        this.putNextEntry(entry);
    }

    @Override
    public void registerEntry(OdsEntry entry) {
        this.manifestElement.add(entry);
    }

    @Override
    public void putNextEntry(OdsEntry entry) throws IOException {
        ZipEntry e = entry.asZipEntry();
        this.zipStream.putNextEntry(e);
    }

    @Override
    public void setComment(String comment) {
        this.zipStream.setComment(comment);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.zipStream.write(bytes);
    }
}

