/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.FileExists;
import com.github.jferard.fastods.util.FileOpenResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class FileOpen
implements FileOpenResult {
    private final OutputStream stream;

    public FileOpen(OutputStream stream) {
        this.stream = stream;
    }

    public static FileOpenResult openFile(File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            return FILE_IS_DIR;
        }
        if (file.exists()) {
            return new FileExists(file);
        }
        return new FileOpen(new FileOutputStream(file));
    }

    public static FileOpenResult openFile(String filename) throws FileNotFoundException {
        File f = new File(filename);
        return FileOpen.openFile(f);
    }

    @Override
    public OutputStream getStream() {
        return this.stream;
    }
}

