/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.attribute.MessageType;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class ErrorMessage
implements XMLConvertible {
    private final boolean display;
    private final MessageType messageType;
    private final String title;

    public static ErrorMessage create() {
        return new ErrorMessage(false, MessageType.STOP, null);
    }

    public ErrorMessage(boolean display, MessageType messageType, String title) {
        this.display = display;
        this.messageType = messageType;
        this.title = title;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:error-message");
        if (this.display) {
            util.appendAttribute(appendable, (CharSequence)"table:display", true);
        }
        if (this.messageType != MessageType.STOP) {
            util.appendAttribute(appendable, (CharSequence)"table:display", this.display);
        }
        if (this.title != null) {
            util.appendAttribute(appendable, (CharSequence)"table:display", this.title);
        }
        appendable.append("/>");
    }
}

