/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.DateValue;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.ObjectToCellValueConverter;
import com.github.jferard.fastods.StringValue;
import com.github.jferard.fastods.TimeValue;
import com.github.jferard.fastods.ToCellValueConverter;
import com.github.jferard.fastods.attribute.CellType;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class SQLToCellValueConverter
implements ToCellValueConverter {
    private final ToCellValueConverter converter;
    private final IntervalConverter intervalConverter;
    private final Charset charset;

    public static SQLToCellValueConverter create(IntervalConverter intervalConverter, String currency, Charset charset) {
        return new SQLToCellValueConverter(new ObjectToCellValueConverter(currency), intervalConverter, charset);
    }

    SQLToCellValueConverter(ToCellValueConverter converter, IntervalConverter intervalConverter, Charset charset) {
        this.converter = converter;
        this.intervalConverter = intervalConverter;
        this.charset = charset;
    }

    @Override
    public CellValue from(Object o) {
        try {
            if (o instanceof Clob) {
                Clob clob = (Clob)o;
                return new StringValue(clob.getSubString(1L, (int)clob.length()));
            }
            if (o instanceof SQLXML) {
                SQLXML sqlxml = (SQLXML)o;
                String string = sqlxml.getString().trim();
                return new StringValue(string);
            }
            if (o instanceof Date) {
                long time = ((Date)o).getTime();
                return new DateValue(new Date(time));
            }
            if (o instanceof Time) {
                long time = ((Time)o).getTime();
                return new DateValue(new Date(time));
            }
            if (o instanceof Timestamp) {
                long time = ((Timestamp)o).getTime();
                return new DateValue(new Date(time));
            }
            TimeValue timeValue = this.intervalConverter.castToInterval(o);
            if (timeValue == null) {
                return this.converter.from(o);
            }
            return timeValue;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CellValue from(CellType type, Object o) throws FastOdsException {
        try {
            switch (type) {
                case STRING: {
                    if (o instanceof Blob) {
                        Blob blob = (Blob)o;
                        return new StringValue(new String(blob.getBytes(1L, (int)blob.length()), this.charset));
                    }
                    if (o instanceof Clob) {
                        Clob clob = (Clob)o;
                        return new StringValue(clob.getSubString(1L, (int)clob.length()));
                    }
                    if (!(o instanceof SQLXML)) break;
                    SQLXML sqlxml = (SQLXML)o;
                    String string = sqlxml.getString().trim();
                    return new StringValue(string);
                }
                case DATE: {
                    if (o instanceof Date) {
                        long time = ((Date)o).getTime();
                        return new DateValue(new Date(time));
                    }
                    if (o instanceof Time) {
                        long time = ((Time)o).getTime();
                        return new DateValue(new Date(time));
                    }
                    if (!(o instanceof Timestamp)) break;
                    long time = ((Timestamp)o).getTime();
                    return new DateValue(new Date(time));
                }
                case TIME: {
                    TimeValue timeValue = this.intervalConverter.castToInterval(o);
                    if (timeValue == null) break;
                    return timeValue;
                }
            }
        }
        catch (SQLException e) {
            throw new FastOdsException(e);
        }
        return this.converter.from(type, o);
    }

    public static interface IntervalConverter {
        public TimeValue castToInterval(Object var1);
    }
}

