/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.TagParameters;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.style.MarginsBuilder;
import com.github.jferard.fastods.util.EqualityUtil;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class Margins
implements TagParameters {
    private final Length all;
    private final Length bottom;
    private final Length left;
    private final Length right;
    private final Length top;

    Margins(Length all, Length top, Length right, Length bottom, Length left) {
        this.all = all;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public boolean areVoid() {
        return this.all == null && this.top == null && this.right == null && this.bottom == null && this.left == null;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        if (this.all == null) {
            if (this.top != null) {
                util.appendAttribute(appendable, (CharSequence)"fo:margin-top", this.top);
            }
            if (this.right != null) {
                util.appendAttribute(appendable, (CharSequence)"fo:margin-right", this.right);
            }
            if (this.bottom != null) {
                util.appendAttribute(appendable, (CharSequence)"fo:margin-bottom", this.bottom);
            }
            if (this.left != null) {
                util.appendAttribute(appendable, (CharSequence)"fo:margin-left", this.left);
            }
        } else {
            util.appendAttribute(appendable, (CharSequence)"fo:margin", this.all);
            if (this.top != null && !this.top.equals(this.all)) {
                util.appendAttribute(appendable, (CharSequence)"fo:margin-top", this.top);
            }
            if (this.right != null && !this.right.equals(this.all)) {
                util.appendAttribute(appendable, (CharSequence)"fo:margin-right", this.right);
            }
            if (this.bottom != null && !this.bottom.equals(this.all)) {
                util.appendAttribute(appendable, (CharSequence)"fo:margin-bottom", this.bottom);
            }
            if (this.left != null && !this.left.equals(this.all)) {
                util.appendAttribute(appendable, (CharSequence)"fo:margin-left", this.left);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Margins)) {
            return false;
        }
        Margins other = (Margins)o;
        return EqualityUtil.equal(this.top, other.top) && EqualityUtil.equal(this.right, other.right) && EqualityUtil.equal(this.bottom, other.bottom) && EqualityUtil.equal(this.left, other.left) && EqualityUtil.equal(this.all, other.all);
    }

    public String toString() {
        return "Margins[top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", left=" + this.left + ", all=" + this.all + "]";
    }

    public int hashCode() {
        return EqualityUtil.hashObjects(this.all, this.bottom, this.left, this.right, this.top);
    }

    public MarginsBuilder toBuilder() {
        return new MarginsBuilder(this.all, this.top, this.right, this.bottom, this.left);
    }
}

