/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.ElementWithEmbeddedStyles;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.DrawFill;
import com.github.jferard.fastods.style.GraphicStyleBuilder;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.ObjectStyleFamily;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class GraphicStyle
implements ObjectStyle,
ElementWithEmbeddedStyles {
    private final String name;
    private final boolean hidden;
    private final DrawFill drawFill;
    private String key;

    public static GraphicStyleBuilder builder(String name) {
        return new GraphicStyleBuilder(name);
    }

    public GraphicStyle(String name, boolean hidden, DrawFill drawFill) {
        this.name = name;
        this.hidden = hidden;
        this.drawFill = drawFill;
    }

    @Override
    public ObjectStyleFamily getFamily() {
        return ObjectStyleFamily.GRAPHIC;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = (Object)((Object)this.getFamily()) + "@" + this.getName();
        }
        return this.key;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:style");
        util.appendAttribute(appendable, (CharSequence)"style:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"style:family", "graphic");
        appendable.append("><style:graphic-properties");
        if (this.drawFill != null) {
            this.drawFill.appendAttributes(util, appendable);
        } else {
            util.appendAttribute(appendable, (CharSequence)"draw:fill", "none");
            util.appendAttribute(appendable, (CharSequence)"draw:stroke", "none");
            util.appendAttribute(appendable, (CharSequence)"draw:textarea-horizontal-align", "center");
            util.appendAttribute(appendable, (CharSequence)"draw:textarea-vertical-align", "middle");
        }
        appendable.append("/></style:style>");
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addContentStyle(this);
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        if (this.drawFill != null) {
            this.drawFill.addEmbeddedStyles(stylesContainer);
        }
    }
}

