/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.ref.CellRef;
import com.github.jferard.fastods.ref.LocalCellAddressParser;
import com.github.jferard.fastods.ref.LocalCellRef;
import com.github.jferard.fastods.ref.TableAddressParser;
import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.ref.TableRef;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

class CellAddressParser {
    private final TableAddressParser tableAddressParser;
    private final LocalCellAddressParser localCellAddressParser;

    public static CellAddressParser create(TableNameUtil tableNameUtil) {
        return new CellAddressParser(new TableAddressParser(tableNameUtil), new LocalCellAddressParser());
    }

    public CellAddressParser(TableAddressParser tableAddressParser, LocalCellAddressParser localCellAddressParser) {
        this.tableAddressParser = tableAddressParser;
        this.localCellAddressParser = localCellAddressParser;
    }

    public CellRef parse(String address) throws ParseException, UnsupportedEncodingException {
        String localCellAddress;
        TableRef tableRef;
        int dotIndex = address.lastIndexOf(46);
        if (dotIndex == -1) {
            tableRef = null;
            localCellAddress = address;
        } else {
            String tableAddress = address.substring(0, dotIndex);
            tableRef = this.tableAddressParser.parse(tableAddress);
            localCellAddress = address.substring(dotIndex + 1);
        }
        LocalCellRef localCellRef = this.localCellAddressParser.parse(localCellAddress);
        return new CellRef(tableRef, localCellRef);
    }
}

