/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.odselement.MetaElement;
import com.github.jferard.fastods.odselement.MetaValueType;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.Date;

public class UserDefined
implements XMLConvertible {
    private final String name;
    private final MetaValueType valueType;
    private final String value;

    public static UserDefined fromBoolean(String name, boolean value) {
        return new UserDefined(name, MetaValueType.BOOLEAN, String.valueOf(value));
    }

    public static UserDefined fromDate(String name, Date value) {
        return new UserDefined(name, MetaValueType.DATE, MetaElement.DF_DATE.format(value));
    }

    public static UserDefined fromFloat(String name, Number value) {
        return new UserDefined(name, MetaValueType.FLOAT, value.toString());
    }

    public static UserDefined fromTime(String name, Date value) {
        return new UserDefined(name, MetaValueType.TIME, MetaElement.DF_TIME.format(value));
    }

    public static UserDefined fromString(String name, String value) {
        return new UserDefined(name, MetaValueType.STRING, value);
    }

    UserDefined(String name, MetaValueType valueType, String value) {
        this.name = name;
        this.valueType = valueType;
        this.value = value;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<meta:user-defined");
        util.appendAttribute(appendable, (CharSequence)"meta:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"meta:type", this.valueType.getValue());
        appendable.append(">").append(this.value).append("</meta:user-defined>");
    }
}

