/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.attribute.CellAlign;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.TextDataStyle;
import com.github.jferard.fastods.odselement.HasFooterHeader;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.FontFace;
import com.github.jferard.fastods.style.FontFaceContainerStyle;
import com.github.jferard.fastods.style.MasterPageStyle;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.PageLayoutStyle;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableCellStyleBuilder;
import com.github.jferard.fastods.util.Container;
import com.github.jferard.fastods.util.MultiContainer;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class StylesContainerImpl
implements StylesContainer {
    private static final FontFace DEFAULT_FONT_FACE = new FontFace("Liberation Sans");
    private final Map<ChildCellStyle, TableCellStyle> anonymousStyleByChildCellStyle;
    private final MultiContainer<String, Dest, DataStyle> dataStylesContainer;
    private final Container<String, MasterPageStyle> masterPageStylesContainer;
    private final Container<String, PageLayoutStyle> pageLayoutStylesContainer;
    private final MultiContainer<String, Dest, ObjectStyle> objectStylesContainer;
    private final Set<FontFace> fontFaces;

    StylesContainerImpl(Logger logger) {
        this.objectStylesContainer = new MultiContainer(logger, Dest.class);
        this.dataStylesContainer = new MultiContainer(logger, Dest.class);
        this.masterPageStylesContainer = new Container(logger);
        this.pageLayoutStylesContainer = new Container(logger);
        this.anonymousStyleByChildCellStyle = new HashMap<ChildCellStyle, TableCellStyle>();
        this.fontFaces = new HashSet<FontFace>();
        this.fontFaces.add(DEFAULT_FONT_FACE);
    }

    @Override
    public TableCellStyle addChildCellStyle(TableCellStyle style, DataStyle dataStyle) {
        ChildCellStyle childKey = new ChildCellStyle(style, dataStyle);
        TableCellStyle anonymousStyle = this.anonymousStyleByChildCellStyle.get(childKey);
        if (anonymousStyle == null) {
            this.addDataStyle(dataStyle);
            if (!style.hasParent()) {
                this.addContentFontFaceContainerStyle(style);
            }
            String name = style.getRealName() + "-_-" + dataStyle.getName();
            TableCellStyleBuilder anonymousStyleBuilder = TableCellStyle.builder(name).parentCellStyle(style).dataStyle(dataStyle);
            if (dataStyle.isHidden()) {
                anonymousStyleBuilder.hidden();
            }
            if (!style.hasTextAlign() && !(dataStyle instanceof TextDataStyle)) {
                anonymousStyleBuilder.textAlign(CellAlign.RIGHT);
            }
            anonymousStyle = anonymousStyleBuilder.build();
            this.addContentFontFaceContainerStyle(anonymousStyle);
            this.anonymousStyleByChildCellStyle.put(childKey, anonymousStyle);
        }
        return anonymousStyle;
    }

    @Override
    public boolean addContentFontFaceContainerStyle(FontFaceContainerStyle ffcStyle) {
        FontFace fontFace = ffcStyle.getFontFace();
        if (fontFace != null) {
            this.fontFaces.add(fontFace);
        }
        return this.addContentStyle(ffcStyle);
    }

    @Override
    public boolean addStylesFontFaceContainerStyle(FontFaceContainerStyle ffcStyle) {
        FontFace fontFace = ffcStyle.getFontFace();
        if (fontFace != null) {
            this.fontFaces.add(fontFace);
        }
        return this.addStylesStyle(ffcStyle);
    }

    @Override
    public boolean addDataStyle(DataStyle dataStyle) {
        if (dataStyle.isHidden()) {
            return this.dataStylesContainer.add(dataStyle.getName(), Dest.CONTENT_AUTOMATIC_STYLES, dataStyle);
        }
        return this.dataStylesContainer.add(dataStyle.getName(), Dest.STYLES_COMMON_STYLES, dataStyle);
    }

    @Override
    public void setDataStylesMode(Container.Mode mode) {
        this.dataStylesContainer.setMode(mode);
    }

    @Override
    public boolean addMasterPageStyle(MasterPageStyle masterPageStyle) {
        if (this.masterPageStylesContainer.add(masterPageStyle.getName(), masterPageStyle)) {
            masterPageStyle.addEmbeddedStyles(this);
            return true;
        }
        return false;
    }

    @Override
    public void setMasterPageStyleMode(Container.Mode mode) {
        this.masterPageStylesContainer.setMode(mode);
    }

    @Override
    public boolean addNewDataStyleFromCellStyle(TableCellStyle style) {
        boolean ret = this.addContentStyle(style);
        return this.addDataStyle(style.getDataStyle()) && ret;
    }

    @Override
    public void setPageLayoutStyleMode(Container.Mode mode) {
        this.pageLayoutStylesContainer.setMode(mode);
    }

    @Override
    public boolean addPageLayoutStyle(PageLayoutStyle pageLayoutStyle) {
        return this.pageLayoutStylesContainer.add(pageLayoutStyle.getName(), pageLayoutStyle);
    }

    @Override
    public void setPageStyleMode(Container.Mode mode) {
        this.setMasterPageStyleMode(mode);
        this.setPageLayoutStyleMode(mode);
    }

    @Override
    public boolean addPageStyle(PageStyle ps) {
        boolean ret = this.addMasterPageStyle(ps.getMasterPageStyle());
        ret = this.addPageLayoutStyle(ps.getPageLayoutStyle()) && ret;
        return ret;
    }

    @Override
    public void setObjectStyleMode(Container.Mode mode) {
        this.objectStylesContainer.setMode(mode);
    }

    @Override
    public boolean addContentStyle(ObjectStyle objectStyle) {
        if (objectStyle.isHidden()) {
            return this.objectStylesContainer.add(objectStyle.getKey(), Dest.CONTENT_AUTOMATIC_STYLES, objectStyle);
        }
        return this.objectStylesContainer.add(objectStyle.getKey(), Dest.STYLES_COMMON_STYLES, objectStyle);
    }

    @Override
    public boolean addStylesStyle(ObjectStyle objectStyle) {
        if (objectStyle.isHidden()) {
            return this.objectStylesContainer.add(objectStyle.getKey(), Dest.STYLES_AUTOMATIC_STYLES, objectStyle);
        }
        return this.objectStylesContainer.add(objectStyle.getKey(), Dest.STYLES_COMMON_STYLES, objectStyle);
    }

    public void debug() {
        this.objectStylesContainer.debug();
        this.dataStylesContainer.debug();
        this.masterPageStylesContainer.debug();
        this.pageLayoutStylesContainer.debug();
    }

    public void freeze() {
        this.objectStylesContainer.freeze();
        this.dataStylesContainer.freeze();
        this.masterPageStylesContainer.freeze();
        this.pageLayoutStylesContainer.freeze();
    }

    public HasFooterHeader hasFooterHeader() {
        boolean hasHeader = false;
        boolean hasFooter = false;
        for (MasterPageStyle ps : this.masterPageStylesContainer.getValues()) {
            if (hasHeader && hasFooter) break;
            hasHeader = hasHeader || ps.hasHeader();
            hasFooter = hasFooter || ps.hasFooter();
        }
        return new HasFooterHeader(hasHeader, hasFooter);
    }

    private void write(Iterable<ObjectStyle> iterable, XMLUtil util, Appendable appendable) throws IOException {
        for (ObjectStyle os : iterable) {
            os.appendXMLContent(util, appendable);
        }
    }

    public void writeContentAutomaticStyles(XMLUtil util, Appendable appendable) throws IOException {
        Iterable<ObjectStyle> styles = this.objectStylesContainer.getValues(Dest.CONTENT_AUTOMATIC_STYLES);
        for (ObjectStyle style : styles) {
            assert (style.isHidden()) : style.toString();
        }
        this.write(styles, util, appendable);
    }

    public void writeHiddenDataStyles(XMLUtil util, Appendable appendable) throws IOException {
        for (DataStyle dataStyle : this.dataStylesContainer.getValues(Dest.CONTENT_AUTOMATIC_STYLES)) {
            dataStyle.appendXMLContent(util, appendable);
        }
    }

    public void writePageLayoutStyles(XMLUtil util, Appendable appendable) throws IOException {
        for (PageLayoutStyle ps : this.pageLayoutStylesContainer.getValues()) {
            assert (ps.isHidden());
            ps.appendXMLToAutomaticStyle(util, appendable);
        }
    }

    public void writeMasterPageStyles(XMLUtil util, Appendable appendable) throws IOException {
        for (MasterPageStyle ps : this.masterPageStylesContainer.getValues()) {
            ps.appendXMLToMasterStyle(util, appendable);
        }
    }

    public void writeStylesAutomaticStyles(XMLUtil util, Appendable appendable) throws IOException {
        Iterable<ObjectStyle> styles = this.objectStylesContainer.getValues(Dest.STYLES_AUTOMATIC_STYLES);
        for (ObjectStyle style : styles) {
            assert (style.isHidden()) : style.toString();
        }
        this.write(styles, util, appendable);
    }

    public void writeStylesCommonStyles(XMLUtil util, Appendable appendable) throws IOException {
        Iterable<ObjectStyle> styles = this.objectStylesContainer.getValues(Dest.STYLES_COMMON_STYLES);
        for (ObjectStyle style : styles) {
            assert (!style.isHidden()) : style.toString() + " - " + style.getName() + TableCellStyle.DEFAULT_CELL_STYLE.toString();
        }
        this.write(styles, util, appendable);
    }

    public void writeVisibleDataStyles(XMLUtil util, Appendable appendable) throws IOException {
        Iterable<DataStyle> dataStyles = this.dataStylesContainer.getValues(Dest.STYLES_COMMON_STYLES);
        for (DataStyle dataStyle : dataStyles) {
            assert (!dataStyle.isHidden()) : dataStyle.toString() + " - " + dataStyle.getName() + TableCellStyle.DEFAULT_CELL_STYLE.toString();
            dataStyle.appendXMLContent(util, appendable);
        }
    }

    public void writeFontFaceDecls(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<office:font-face-decls>");
        for (FontFace fontFace : this.fontFaces) {
            fontFace.appendXMLContent(util, appendable);
        }
        appendable.append("</office:font-face-decls>");
    }

    public static enum Dest {
        CONTENT_AUTOMATIC_STYLES,
        STYLES_AUTOMATIC_STYLES,
        STYLES_COMMON_STYLES;

    }

    private static class ChildCellStyle {
        private final TableCellStyle style;
        private final DataStyle dataStyle;

        ChildCellStyle(TableCellStyle style, DataStyle dataStyle) {
            this.style = style;
            this.dataStyle = dataStyle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ChildCellStyle)) {
                return false;
            }
            ChildCellStyle other = (ChildCellStyle)o;
            return this.style.getKey().equals(other.style.getKey()) && this.dataStyle.getName().equals(other.dataStyle.getName());
        }

        public int hashCode() {
            return this.style.getKey().hashCode() * 31 + this.dataStyle.getName().hashCode();
        }
    }
}

