/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.EncryptParameters;
import com.github.jferard.fastods.odselement.EncryptedOdsEntry;
import com.github.jferard.fastods.odselement.OdsEntry;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.zip.ZipEntry;

public class StandardOdsEntry
implements OdsEntry {
    private final String fullPath;
    private final CharSequence mediaType;
    private final CharSequence version;

    public StandardOdsEntry(String fullPath, CharSequence mediaType, CharSequence version) {
        this.fullPath = fullPath;
        this.mediaType = mediaType;
        this.version = version;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<manifest:file-entry");
        util.appendAttribute(appendable, (CharSequence)"manifest:full-path", this.fullPath);
        if (this.mediaType != null) {
            util.appendAttribute(appendable, (CharSequence)"manifest:media-type", this.mediaType);
        }
        if (this.version != null) {
            util.appendAttribute(appendable, (CharSequence)"manifest:version", this.version);
        }
        appendable.append("/>");
    }

    @Override
    public OdsEntry encryptParameters(EncryptParameters encryptParameters) {
        return new EncryptedOdsEntry(this.fullPath, this.mediaType, this.version, encryptParameters);
    }

    @Override
    public ZipEntry asZipEntry() {
        return new ZipEntry(this.fullPath);
    }

    @Override
    public boolean neverEncrypt() {
        return this.fullPath.endsWith("/");
    }

    public String toString() {
        return "OdsEntry[path=" + this.fullPath + "]";
    }
}

