/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.odselement.config.ConfigBlock;
import com.github.jferard.fastods.odselement.config.ConfigElement;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntrySet;
import com.github.jferard.fastods.odselement.config.ConfigItemMapIndexed;
import com.github.jferard.fastods.odselement.config.ConfigItemMapNamed;
import com.github.jferard.fastods.odselement.config.ConfigItemSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Settings {
    private final ConfigItemMapEntrySet firstView;
    private final List<ConfigBlock> rootBlocks;
    private final ConfigItemMapNamed tablesMap;
    private final Map<String, ConfigItemMapEntrySet> viewById;

    public static Settings create() {
        ConfigItemSet viewSettings = new ConfigItemSet("ooo:view-settings");
        viewSettings.add(ConfigItem.create(ConfigElement.VISIBLE_AREA_TOP, "0"));
        viewSettings.add(ConfigItem.create(ConfigElement.VISIBLE_AREA_LEFT, "0"));
        viewSettings.add(ConfigItem.create(ConfigElement.VISIBLE_AREA_WIDTH, "680"));
        viewSettings.add(ConfigItem.create(ConfigElement.VISIBLE_AREA_HEIGHT, "400"));
        ConfigItemMapEntrySet firstView = ConfigItemMapEntrySet.createSet();
        firstView.add(ConfigItem.create(ConfigElement.ZOOM_TYPE, "0"));
        firstView.add(ConfigItem.create(ConfigElement.ZOOM_VALUE, "100"));
        firstView.add(ConfigItem.create(ConfigElement.SHOW_ZERO_VALUES, "true"));
        firstView.add(ConfigItem.create(ConfigElement.SHOW_NOTES, "true"));
        firstView.add(ConfigItem.create(ConfigElement.SHOW_GRID, "true"));
        firstView.add(ConfigItem.create(ConfigElement.GRID_COLOR, "12632256"));
        firstView.add(ConfigItem.create(ConfigElement.SHOW_PAGE_BREAKS, "true"));
        firstView.add(ConfigItem.create(ConfigElement.HAS_COLUMN_ROW_HEADERS, "true"));
        firstView.add(ConfigItem.create(ConfigElement.HAS_SHEET_TABS, "true"));
        firstView.add(ConfigItem.create(ConfigElement.IS_OUTLINE_SYMBOLS_SET, "true"));
        firstView.add(ConfigItem.create(ConfigElement.IS_SNAP_TO_RASTER, "false"));
        firstView.add(ConfigItem.create(ConfigElement.RASTER_IS_VISIBLE, "false"));
        firstView.add(ConfigItem.create(ConfigElement.RASTER_RESOLUTION_X, "1000"));
        firstView.add(ConfigItem.create(ConfigElement.RASTER_RESOLUTION_Y, "1000"));
        firstView.add(ConfigItem.create(ConfigElement.RASTER_SUBDIVISION_X, "1"));
        firstView.add(ConfigItem.create(ConfigElement.RASTER_SUBDIVISION_Y, "1"));
        firstView.add(ConfigItem.create(ConfigElement.IS_RASTER_AXIS_SYNCHRONIZED, "true"));
        firstView.add(ConfigItem.create(ConfigElement.VIEW_ID, "View1"));
        firstView.add(ConfigItem.create(ConfigElement.ACTIVE_TABLE, "Sheet1"));
        firstView.add(ConfigItem.create(ConfigElement.HORIZONTAL_SCROLLBAR_WIDTH, "270"));
        firstView.add(ConfigItem.create(ConfigElement.PAGE_VIEW_ZOOM_VALUE, "60"));
        firstView.add(ConfigItem.create(ConfigElement.SHOW_PAGE_BREAK_PREVIEW, "false"));
        ConfigItemSet configurationSettings = new ConfigItemSet("ooo:configuration-settings");
        configurationSettings.add(ConfigItem.create(ConfigElement.SHOW_ZERO_VALUES, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.SHOW_NOTES, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.SHOW_GRID, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.GRID_COLOR, "12632256"));
        configurationSettings.add(ConfigItem.create(ConfigElement.SHOW_PAGE_BREAKS, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.HAS_COLUMN_ROW_HEADERS, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.HAS_SHEET_TABS, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.IS_OUTLINE_SYMBOLS_SET, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.LINK_UPDATE_MODE, "3"));
        configurationSettings.add(ConfigItem.create(ConfigElement.PRINTER_NAME, ""));
        configurationSettings.add(ConfigItem.create(ConfigElement.PRINTER_SETUP, ""));
        configurationSettings.add(ConfigItem.create(ConfigElement.APPLY_USER_DATA, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.CHARACTER_COMPRESSION_TYPE, "0"));
        configurationSettings.add(ConfigItem.create(ConfigElement.IS_KERN_ASIAN_PUNCTUATION, "false"));
        configurationSettings.add(ConfigItem.create(ConfigElement.SAVE_VERSION_ON_CLOSE, "false"));
        configurationSettings.add(ConfigItem.create(ConfigElement.UPDATE_FROM_TEMPLATE, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.AUTO_CALCULATE, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.IS_SNAP_TO_RASTER, "false"));
        configurationSettings.add(ConfigItem.create(ConfigElement.RASTER_IS_VISIBLE, "false"));
        configurationSettings.add(ConfigItem.create(ConfigElement.RASTER_RESOLUTION_X, "1000"));
        configurationSettings.add(ConfigItem.create(ConfigElement.RASTER_RESOLUTION_Y, "1000"));
        configurationSettings.add(ConfigItem.create(ConfigElement.RASTER_SUBDIVISION_X, "1"));
        configurationSettings.add(ConfigItem.create(ConfigElement.RASTER_SUBDIVISION_Y, "1"));
        configurationSettings.add(ConfigItem.create(ConfigElement.IS_RASTER_AXIS_SYNCHRONIZED, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.ALLOW_PRINT_JOB_CANCEL, "true"));
        configurationSettings.add(ConfigItem.create(ConfigElement.LOAD_READONLY, "false"));
        return Settings.create(viewSettings, firstView, configurationSettings);
    }

    static Settings create(ConfigItemSet viewSettings, ConfigItemMapEntrySet firstView, ConfigItemSet configurationSettings) {
        ArrayList<ConfigBlock> rootBlocks = new ArrayList<ConfigBlock>();
        ConfigItemMapIndexed views = new ConfigItemMapIndexed("Views");
        HashMap<String, ConfigItemMapEntrySet> viewById = new HashMap<String, ConfigItemMapEntrySet>();
        ConfigItemMapNamed tablesMap = new ConfigItemMapNamed("Tables");
        return new Settings(rootBlocks, viewSettings, views, viewById, firstView, tablesMap, configurationSettings);
    }

    Settings(List<ConfigBlock> rootBlocks, ConfigItemSet viewSettings, ConfigItemMapIndexed views, Map<String, ConfigItemMapEntrySet> viewById, ConfigItemMapEntrySet firstView, ConfigItemMapNamed tablesMap, ConfigItemSet configurationSettings) {
        this.rootBlocks = rootBlocks;
        this.viewById = viewById;
        this.firstView = firstView;
        this.tablesMap = tablesMap;
        views.add(this.firstView);
        viewSettings.add(views);
        this.rootBlocks.add(viewSettings);
        this.viewById.put(((ConfigItem)firstView.getByName("ViewId")).getValue(), firstView);
        this.firstView.add(this.tablesMap);
        this.rootBlocks.add(configurationSettings);
    }

    public void addTable(Table table) {
        ConfigItemMapEntry configEntry = table.getConfigEntry();
        this.addTableConfig(configEntry);
    }

    public void addTableConfig(ConfigItemMapEntry configEntry) {
        this.tablesMap.put(configEntry);
    }

    public List<ConfigBlock> getRootBlocks() {
        return this.rootBlocks;
    }

    public void setActiveTable(Table table) {
        this.firstView.add(ConfigItem.create(ConfigElement.ACTIVE_TABLE, table.getName()));
    }

    public void setTables(List<Table> tables) {
        this.tablesMap.clear();
        for (Table table : tables) {
            this.addTableConfig(table.getConfigEntry());
        }
    }

    public void setViewSetting(String viewId, String item, String value) {
        ConfigItemMapEntrySet view = this.viewById.get(viewId);
        if (view == null) {
            return;
        }
        view.set(item, value);
    }
}

