/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.OdsEntry;
import com.github.jferard.fastods.odselement.UnregisteredOdsEntry;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ManifestElement
implements OdsElement {
    public static final String META_INF_MANIFEST_XML = "META-INF/manifest.xml";
    private final Set<OdsEntry> manifestEntries;

    public static ManifestElement create() {
        return new ManifestElement(new HashSet<OdsEntry>());
    }

    ManifestElement(Set<OdsEntry> initialEntries) {
        this.manifestEntries = new HashSet<OdsEntry>(initialEntries);
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putNextEntry(new UnregisteredOdsEntry(META_INF_MANIFEST_XML));
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.append("<manifest:manifest");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
        util.appendAttribute((Appendable)writer, (CharSequence)"manifest:version", "1.2");
        writer.append(">");
        List<OdsEntry> entries = this.getManifestEntries();
        for (OdsEntry entry : entries) {
            entry.appendXMLContent(util, writer);
        }
        writer.append("</manifest:manifest>");
        writer.closeEntry();
    }

    private List<OdsEntry> getManifestEntries() {
        ArrayList<OdsEntry> entries = new ArrayList<OdsEntry>(this.manifestEntries);
        Collections.sort(entries, new Comparator<OdsEntry>(){

            @Override
            public int compare(OdsEntry o1, OdsEntry o2) {
                return o1.asZipEntry().getName().compareTo(o2.asZipEntry().getName());
            }
        });
        return entries;
    }

    public void add(OdsEntry manifestEntry) {
        this.manifestEntries.add(manifestEntry);
    }
}

