/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.ValidationsContainer;
import com.github.jferard.fastods.attribute.CellType;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.FlushPosition;
import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.ScriptEventListener;
import com.github.jferard.fastods.odselement.StandardOdsEntry;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.StylesContainerImpl;
import com.github.jferard.fastods.odselement.StylesElement;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.AutoFilter;
import com.github.jferard.fastods.util.IntegerRepresentationCache;
import com.github.jferard.fastods.util.PilotTable;
import com.github.jferard.fastods.util.UniqueList;
import com.github.jferard.fastods.util.Validation;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContentElement
implements OdsElement {
    private static final Map<String, String> CONTENT_NAMESPACE_BY_PREFIX = new HashMap<String, String>();
    private final FlushPosition flushPosition;
    private final DataStyles format;
    private final PositionUtil positionUtil;
    private final StylesContainerImpl stylesContainer;
    private final UniqueList<Table> tables;
    private final IntegerRepresentationCache cache;
    private final XMLUtil xmlUtil;
    private final boolean libreOfficeMode;
    private final List<ScriptEventListener> scriptEvents;
    private final ValidationsContainer validationsContainer;
    private final Map<String, String> additionalNamespaceByPrefix;
    private List<AutoFilter> autoFilters;
    private List<PilotTable> pilotTables;

    ContentElement(PositionUtil positionUtil, XMLUtil xmlUtil, IntegerRepresentationCache cache, DataStyles format, boolean libreOfficeMode, StylesContainerImpl stylesContainer, Map<String, String> additionalNamespaceByPrefix) {
        this.cache = cache;
        this.xmlUtil = xmlUtil;
        this.positionUtil = positionUtil;
        this.format = format;
        this.libreOfficeMode = libreOfficeMode;
        this.stylesContainer = stylesContainer;
        this.additionalNamespaceByPrefix = additionalNamespaceByPrefix;
        this.tables = new UniqueList();
        this.flushPosition = new FlushPosition();
        this.scriptEvents = new ArrayList<ScriptEventListener>();
        this.validationsContainer = new ValidationsContainer();
    }

    public TableCellStyle addChildCellStyle(TableCellStyle style, CellType type) {
        DataStyle dataStyle = this.format.getDataStyle(type);
        TableCellStyle newStyle = dataStyle == null ? style : this.stylesContainer.addChildCellStyle(style, dataStyle);
        return newStyle;
    }

    @Deprecated
    public Table addTable(String name, int rowCapacity, int columnCapacity) {
        Table table = this.tables.getByName(name);
        if (table == null) {
            table = Table.create(this, this.positionUtil, this.cache, this.xmlUtil, name, rowCapacity, columnCapacity, this.stylesContainer, this.format, this.libreOfficeMode, this.validationsContainer);
            this.tables.add(table);
        }
        return table;
    }

    public boolean addTable(Table table) {
        boolean add;
        Table t = this.tables.getByName(table.getName());
        boolean bl = add = t == null;
        if (add) {
            this.tables.add(table);
        }
        return add;
    }

    public Table createTable(String name, int rowCapacity, int columnCapacity) {
        return Table.create(this, this.positionUtil, this.cache, this.xmlUtil, name, rowCapacity, columnCapacity, this.stylesContainer, this.format, this.libreOfficeMode, this.validationsContainer);
    }

    public Table getLastTable() {
        int size = this.tables.size();
        return size <= 0 ? null : (Table)this.tables.get(size - 1);
    }

    public StylesContainer getStyleTagsContainer() {
        return this.stylesContainer;
    }

    public Table getTable(int tableIndex) {
        return (Table)this.tables.get(tableIndex);
    }

    public Table getTable(String name) {
        return this.tables.getByName(name);
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public List<Table> getTables() {
        return this.tables;
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        this.writePreamble(util, writer);
        for (Table table : this.tables) {
            table.appendXMLContent(util, writer);
        }
        this.writePostamble(util, writer);
    }

    public void writePreamble(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putAndRegisterNextEntry(new StandardOdsEntry("content.xml", "text/xml", null));
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.append("<office:document-content");
        for (Map.Entry<String, String> entry : CONTENT_NAMESPACE_BY_PREFIX.entrySet()) {
            util.appendAttribute((Appendable)writer, (CharSequence)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.additionalNamespaceByPrefix.entrySet()) {
            util.appendAttribute((Appendable)writer, (CharSequence)entry.getKey(), entry.getValue());
        }
        util.appendAttribute((Appendable)writer, (CharSequence)"office:version", "1.2");
        writer.append(">");
        this.writeEvents(util, writer);
        this.stylesContainer.writeFontFaceDecls(util, writer);
        writer.append("<office:automatic-styles>");
        this.stylesContainer.writeHiddenDataStyles(util, writer);
        this.stylesContainer.writeContentAutomaticStyles(util, writer);
        writer.append("</office:automatic-styles>");
        writer.append("<office:body>");
        writer.append("<office:spreadsheet>");
        this.appendValidations(util, writer);
    }

    private void appendValidations(XMLUtil util, Appendable appendable) throws IOException {
        Collection<Validation> validations = this.validationsContainer.getValidations();
        if (validations == null || validations.isEmpty()) {
            return;
        }
        appendable.append("<table:content-validations>");
        for (Validation validation : validations) {
            validation.appendXMLContent(util, appendable);
        }
        appendable.append("</table:content-validations>");
    }

    public void writePostamble(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        if (this.autoFilters != null) {
            this.appendAutoFilters(util, writer);
        }
        if (this.pilotTables != null) {
            this.appendPilotTables(util, writer);
        }
        writer.append("</office:spreadsheet>");
        writer.append("</office:body>");
        writer.append("</office:document-content>");
        writer.closeEntry();
    }

    public void writeEvents(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        if (this.scriptEvents.isEmpty()) {
            return;
        }
        writer.append("<office:scripts><office:event-listeners>");
        for (ScriptEventListener event : this.scriptEvents) {
            event.appendXMLContent(util, writer);
        }
        writer.append("</office:event-listeners></office:scripts>");
    }

    private void appendAutoFilters(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:database-ranges>");
        for (AutoFilter autoFilter : this.autoFilters) {
            autoFilter.appendXMLContent(util, appendable);
        }
        appendable.append("</table:database-ranges>");
    }

    private void appendPilotTables(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:data-pilot-tables>");
        for (PilotTable pilotTable : this.pilotTables) {
            pilotTable.appendXMLContent(util, appendable);
        }
        appendable.append("</table:data-pilot-tables>");
    }

    public void addAutoFilter(AutoFilter autoFilter) {
        if (this.autoFilters == null) {
            this.autoFilters = new ArrayList<AutoFilter>();
        }
        this.autoFilters.add(autoFilter);
    }

    public void addEvents(ScriptEventListener ... events) {
        this.scriptEvents.addAll(Arrays.asList(events));
    }

    public void addPilotTable(PilotTable pilotTable) {
        if (this.pilotTables == null) {
            this.pilotTables = new ArrayList<PilotTable>();
        }
        this.pilotTables.add(pilotTable);
    }

    static {
        CONTENT_NAMESPACE_BY_PREFIX.putAll(StylesElement.STYLES_NAMESPACE_BY_PREFIX);
        CONTENT_NAMESPACE_BY_PREFIX.put("xmlns:xforms", "http://www.w3.org/2002/xforms");
        CONTENT_NAMESPACE_BY_PREFIX.put("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        CONTENT_NAMESPACE_BY_PREFIX.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        CONTENT_NAMESPACE_BY_PREFIX.put("xmlns:of", "urn:oasis:names:tc:opendocument:xmlns:of:1.2");
    }
}

