/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.OdsAsyncFlusher;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class PreprocessedRowsFlusher
implements OdsAsyncFlusher {
    private static final int STRING_BUILDER_SIZE = 32768;
    private final CharSequence cs;

    public static PreprocessedRowsFlusher create(XMLUtil xmlUtil, List<TableRowImpl> tableRows) throws IOException {
        StringBuilder sb = new StringBuilder(32768);
        for (TableRowImpl row : tableRows) {
            TableRowImpl.appendXMLToTable(row, xmlUtil, sb);
        }
        Collections.fill(tableRows, null);
        return new PreprocessedRowsFlusher(sb);
    }

    PreprocessedRowsFlusher(CharSequence cs) throws IOException {
        this.cs = cs;
    }

    @Override
    public void flushInto(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        writer.append(this.cs);
    }

    @Override
    public boolean isEnd() {
        return false;
    }
}

