/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.ElementWithEmbeddedStyles;
import com.github.jferard.fastods.Footer;
import com.github.jferard.fastods.Header;
import com.github.jferard.fastods.PageSectionContent;
import com.github.jferard.fastods.PageSectionStyle;
import com.github.jferard.fastods.RegionPageSectionBuilder;
import com.github.jferard.fastods.SimplePageSectionBuilder;
import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class PageSection
implements ElementWithEmbeddedStyles {
    private final PageSectionContent content;
    private final PageSectionStyle style;

    public static void appendPageSectionStyleXMLToAutomaticStyle(Header header, XMLUtil util, Appendable appendable) throws IOException {
        if (header == null) {
            appendable.append("<style:header-style />");
        } else {
            header.appendPageSectionStyleXMLToAutomaticStyle(util, appendable);
        }
    }

    public static void appendPageSectionStyleXMLToAutomaticStyle(Footer footer, XMLUtil util, Appendable appendable) throws IOException {
        if (footer == null) {
            appendable.append("<style:footer-style />");
        } else {
            footer.appendPageSectionStyleXMLToAutomaticStyle(util, appendable);
        }
    }

    public static RegionPageSectionBuilder regionBuilder() {
        return new RegionPageSectionBuilder();
    }

    public static SimplePageSectionBuilder simpleBuilder() {
        return new SimplePageSectionBuilder();
    }

    public static Footer simpleFooter(String text, TextStyle ts) {
        return ((SimplePageSectionBuilder)new SimplePageSectionBuilder().text(Text.styledContent(text, ts))).buildFooter();
    }

    public static Header simpleHeader(String text, TextStyle ts) {
        return ((SimplePageSectionBuilder)new SimplePageSectionBuilder().text(Text.styledContent(text, ts))).buildHeader();
    }

    PageSection(PageSectionContent content, PageSectionStyle style) {
        this.content = content;
        this.style = style;
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        this.content.addEmbeddedStyles(stylesContainer);
    }

    public void appendPageSectionStyleXMLToAutomaticStyle(XMLUtil util, Appendable appendable, Type pageSectionType) throws IOException {
        PageSectionStyle.appendFooterHeaderStyleXMLToAutomaticStyle(this.style, pageSectionType, util, appendable);
    }

    public void appendXMLToMasterStyle(XMLUtil util, Appendable appendable) throws IOException {
        this.content.appendXMLToMasterStyle(util, appendable);
    }

    public static enum Type {
        FOOTER("footer"),
        HEADER("header");

        private final String typeName;

        private Type(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

