/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.ZipUTF8Writer;
import com.github.jferard.fastods.util.ZipUTF8WriterImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipOutputStream;

public class ZipUTF8WriterBuilder {
    private static final int DEFAULT_BUFFER = -1;
    private static final int NO_BUFFER = -2;
    private int level = 1;
    private int writerBufferSize = -1;
    private int zipBufferSize = -1;

    ZipUTF8WriterBuilder() {
    }

    public ZipUTF8Writer build(OutputStream out) {
        Writer bufferedWriter;
        OutputStream bufferedOut;
        switch (this.zipBufferSize) {
            case -2: {
                bufferedOut = out;
                break;
            }
            case -1: {
                bufferedOut = new BufferedOutputStream(out);
                break;
            }
            default: {
                bufferedOut = new BufferedOutputStream(out, this.zipBufferSize);
            }
        }
        ZipOutputStream zipOut = new ZipOutputStream(bufferedOut);
        zipOut.setMethod(8);
        zipOut.setLevel(this.level);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipOut, ZipUTF8Writer.UTF_8);
        switch (this.writerBufferSize) {
            case -2: {
                bufferedWriter = writer;
                break;
            }
            case -1: {
                bufferedWriter = new BufferedWriter(writer);
                break;
            }
            default: {
                bufferedWriter = new BufferedWriter(writer, this.writerBufferSize);
            }
        }
        return new ZipUTF8WriterImpl(zipOut, bufferedWriter);
    }

    public ZipUTF8WriterBuilder defaultWriterBuffer() {
        this.writerBufferSize = -1;
        return this;
    }

    public ZipUTF8WriterBuilder defaultZipBuffer() {
        this.zipBufferSize = -1;
        return this;
    }

    public ZipUTF8WriterBuilder level(int level) {
        this.level = level;
        return this;
    }

    public ZipUTF8WriterBuilder noWriterBuffer() {
        this.writerBufferSize = -2;
        return this;
    }

    public ZipUTF8WriterBuilder noZipBuffer() {
        this.zipBufferSize = -2;
        return this;
    }

    public ZipUTF8WriterBuilder writerBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.writerBufferSize = size;
        return this;
    }

    public ZipUTF8WriterBuilder zipBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.zipBufferSize = size;
        return this;
    }
}

