/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.Container;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MultiContainer<K, S extends Enum<S>, V> {
    private final Map<K, S> subContainerByKey;
    private final Map<S, Map<K, V>> valueByKeyBySubContainer;
    private final Logger logger;
    private boolean closed;
    private boolean debug;
    private Container.Mode mode;

    public MultiContainer(Logger logger, Class<S> subContainersEnum) {
        this.logger = logger;
        this.subContainerByKey = new HashMap<K, S>();
        this.valueByKeyBySubContainer = new HashMap<S, Map<K, V>>();
        for (Enum subContainer : (Enum[])subContainersEnum.getEnumConstants()) {
            this.valueByKeyBySubContainer.put(subContainer, new HashMap());
        }
        this.closed = false;
        this.debug = false;
        this.mode = Container.Mode.CREATE_OR_UPDATE;
    }

    public void setMode(Container.Mode mode) {
        this.mode = mode;
    }

    public boolean add(K key, S subContainer, V value) {
        Enum curSubContainer = (Enum)this.subContainerByKey.get(key);
        if (curSubContainer == null) {
            if (this.mode == Container.Mode.UPDATE) {
                return false;
            }
        } else {
            if (this.mode == Container.Mode.CREATE) {
                return false;
            }
            if (subContainer != curSubContainer) {
                if (this.closed) {
                    throw new IllegalStateException("MultiContainer put(" + key + ", " + value + ") in " + subContainer);
                }
                this.valueByKeyBySubContainer.get(curSubContainer).remove(key);
            }
        }
        if (subContainer != curSubContainer) {
            this.subContainerByKey.put(key, subContainer);
        }
        Map<K, V> valueByKey = this.valueByKeyBySubContainer.get(subContainer);
        if (this.closed && !valueByKey.containsKey(key)) {
            throw new IllegalStateException("MultiContainer put(" + key + ", " + value + ") in " + subContainer);
        }
        if (this.debug && !valueByKey.containsKey(key)) {
            this.logger.severe("MultiContainer put(" + key + ", " + value + ") in " + subContainer);
        }
        valueByKey.put(key, value);
        return true;
    }

    public V get(K key, S subContainer) {
        Map<K, V> valueByKey = this.valueByKeyBySubContainer.get(subContainer);
        return valueByKey == null ? null : (V)valueByKey.get(key);
    }

    public void debug() {
        this.debug = true;
    }

    public void freeze() {
        this.closed = true;
    }

    public Map<K, V> getValueByKey(S subContainer) {
        return this.valueByKeyBySubContainer.get(subContainer);
    }

    public Iterable<V> getValues(S subContainer) {
        return this.valueByKeyBySubContainer.get(subContainer).values();
    }

    public String toString() {
        return this.valueByKeyBySubContainer.toString();
    }
}

