/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.TagParameters;
import com.github.jferard.fastods.attribute.BorderAttribute;
import com.github.jferard.fastods.util.EqualityUtil;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class Borders
implements TagParameters {
    private final BorderAttribute all;
    private final BorderAttribute bottom;
    private final BorderAttribute left;
    private final BorderAttribute right;
    private final BorderAttribute top;

    Borders(BorderAttribute all, BorderAttribute top, BorderAttribute right, BorderAttribute bottom, BorderAttribute left) {
        this.all = all;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public boolean areVoid() {
        return this.all == null && this.top == null && this.right == null && this.bottom == null && this.left == null;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        if (this.all == null) {
            if (this.top != null) {
                this.top.appendXMLAttribute(util, appendable, "fo:border-top");
            }
            if (this.right != null) {
                this.right.appendXMLAttribute(util, appendable, "fo:border-right");
            }
            if (this.bottom != null) {
                this.bottom.appendXMLAttribute(util, appendable, "fo:border-bottom");
            }
            if (this.left != null) {
                this.left.appendXMLAttribute(util, appendable, "fo:border-left");
            }
        } else {
            this.all.appendXMLAttribute(util, appendable, "fo:border");
            if (this.top != null && !this.top.equals(this.all)) {
                this.top.appendXMLAttribute(util, appendable, "fo:border-top");
            }
            if (this.right != null && !this.right.equals(this.all)) {
                this.right.appendXMLAttribute(util, appendable, "fo:border-right");
            }
            if (this.bottom != null && !this.bottom.equals(this.all)) {
                this.bottom.appendXMLAttribute(util, appendable, "fo:border-bottom");
            }
            if (this.left != null && !this.left.equals(this.all)) {
                this.left.appendXMLAttribute(util, appendable, "fo:border-left");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Borders)) {
            return false;
        }
        Borders other = (Borders)o;
        return EqualityUtil.equal(this.top, other.top) && EqualityUtil.equal(this.right, other.right) && EqualityUtil.equal(this.bottom, other.bottom) && EqualityUtil.equal(this.left, other.left) && EqualityUtil.equal(this.all, other.all);
    }

    public String toString() {
        return "Borders[top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", left=" + this.left + ", all=" + this.all + "]";
    }

    public int hashCode() {
        return EqualityUtil.hashObjects(this.all, this.bottom, this.left, this.right, this.top);
    }
}

