/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.ref.TableRef;
import java.io.File;

public class TableRefBuilder {
    private final TableNameUtil tableNameUtil;
    private int status;
    private String tableName;
    private String filename;

    TableRefBuilder(TableNameUtil tableNameUtil) {
        this.tableNameUtil = tableNameUtil;
        this.filename = null;
        this.status = 0;
    }

    public TableRefBuilder absTable(String tableName) {
        this.tableName = tableName;
        this.status |= 4;
        return this;
    }

    public TableRefBuilder table(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableRefBuilder table(Table table) {
        this.tableName = table.getName();
        return this;
    }

    public TableRefBuilder absTable(Table table) {
        this.tableName = table.getName();
        this.status |= 4;
        return this;
    }

    public TableRefBuilder file(String filename) {
        this.filename = filename;
        return this;
    }

    public TableRefBuilder file(File file) {
        this.filename = file.getPath();
        return this;
    }

    public TableRef build() {
        if (this.tableName == null) {
            return null;
        }
        return new TableRef(this.tableNameUtil, this.filename, this.tableName, this.status);
    }
}

