/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.ref.LocalCellRefBuilder;
import com.github.jferard.fastods.util.EqualityUtil;
import java.io.IOException;

class LocalCellRef {
    public static final char ABS_SIGN = '$';
    static final int ABSOLUTE_COL = 1;
    static final int ABSOLUTE_ROW = 2;
    private final int c;
    private final int status;
    private final int r;

    public static LocalCellRefBuilder builder() {
        return new LocalCellRefBuilder();
    }

    public LocalCellRef(int r, int c, int status) {
        this.r = r;
        this.c = c;
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalCellRef)) {
            return false;
        }
        LocalCellRef other = (LocalCellRef)o;
        return this.r == other.r && this.c == other.c && this.status == other.status;
    }

    public int hashCode() {
        return EqualityUtil.hashObjects(this.r, this.c, this.status);
    }

    public int getColumn() {
        return this.c;
    }

    public int getRow() {
        return this.r;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    public void write(Appendable appendable) throws IOException {
        StringBuilder tempSb = this.getColStringBuilder();
        if ((this.status & 1) == 1) {
            appendable.append('$');
        }
        appendable.append(tempSb);
        if ((this.status & 2) == 2) {
            appendable.append('$');
        }
        appendable.append(String.valueOf(this.r + 1));
    }

    private StringBuilder getColStringBuilder() {
        StringBuilder tempSb = new StringBuilder();
        int col = this.c;
        while (col >= 26) {
            tempSb.insert(0, (char)(65 + col % 26));
            col = col / 26 - 1;
        }
        tempSb.insert(0, (char)(65 + col));
        return tempSb;
    }
}

