/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.FinalizeFlusher;
import com.github.jferard.fastods.ImmutableElementsFlusher;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.PrepareContentFlusher;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.attribute.CellType;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.ContentElement;
import com.github.jferard.fastods.odselement.ManifestElement;
import com.github.jferard.fastods.odselement.MetaElement;
import com.github.jferard.fastods.odselement.MimetypeElement;
import com.github.jferard.fastods.odselement.ScriptEventListener;
import com.github.jferard.fastods.odselement.SettingsElement;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.StylesContainerImpl;
import com.github.jferard.fastods.odselement.StylesElement;
import com.github.jferard.fastods.odselement.config.ConfigElement;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.odselement.config.ManifestEntry;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.style.FontFaceContainerStyle;
import com.github.jferard.fastods.style.MasterPageStyle;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.PageLayoutStyle;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.AutoFilter;
import com.github.jferard.fastods.util.Container;
import com.github.jferard.fastods.util.PilotTable;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class OdsElements
implements StylesContainer {
    public static final String SC_SPLIT_NORMAL = "0";
    public static final String SC_SPLIT_FIX = "2";
    private static final String[] EMPTY_ELEMENT_NAMES = new String[]{"Thumbnails/", "Configurations2/accelerator/current.xml", "Configurations2/floater/", "Configurations2/images/Bitmaps/", "Configurations2/menubar/", "Configurations2/popupmenu/", "Configurations2/progressbar/", "Configurations2/statusbar/", "Configurations2/toolbar/"};
    private final ContentElement contentElement;
    private final Logger logger;
    private final ManifestElement manifestElement;
    private final MetaElement metaElement;
    private final MimetypeElement mimeTypeElement;
    private final SettingsElement settingsElement;
    private final StylesContainerImpl stylesContainer;
    private final StylesElement stylesElement;
    private final Map<String, CharSequence> extraFileByName;
    private NamedOdsFileWriter observer;

    public static OdsElements create(PositionUtil positionUtil, XMLUtil xmlUtil, WriteUtil writeUtil, DataStyles format, boolean libreOfficeMode) {
        Logger logger = Logger.getLogger(OdsElements.class.getName());
        MimetypeElement mimetypeElement = new MimetypeElement();
        ManifestElement manifestElement = ManifestElement.create();
        SettingsElement settingsElement = SettingsElement.create();
        MetaElement metaElement = new MetaElement();
        StylesContainerImpl stylesContainer = new StylesContainerImpl(logger);
        StylesElement stylesElement = new StylesElement(stylesContainer);
        ContentElement contentElement = new ContentElement(positionUtil, xmlUtil, writeUtil, format, libreOfficeMode, stylesContainer);
        return new OdsElements(logger, stylesContainer, mimetypeElement, manifestElement, settingsElement, metaElement, contentElement, stylesElement);
    }

    OdsElements(Logger logger, StylesContainerImpl stylesContainer, MimetypeElement mimeTypeElement, ManifestElement manifestElement, SettingsElement settingsElement, MetaElement metaElement, ContentElement contentElement, StylesElement stylesElement) {
        this.logger = logger;
        this.mimeTypeElement = mimeTypeElement;
        this.manifestElement = manifestElement;
        this.settingsElement = settingsElement;
        this.metaElement = metaElement;
        this.contentElement = contentElement;
        this.stylesElement = stylesElement;
        this.stylesContainer = stylesContainer;
        this.extraFileByName = new HashMap<String, CharSequence>();
    }

    public void addObserver(NamedOdsFileWriter o) {
        this.observer = o;
    }

    public void addCellStyle(TableCellStyle style, CellType ... types) {
        this.stylesContainer.addContentStyle(style);
        for (CellType type : types) {
            this.contentElement.addChildCellStyle(style, type);
        }
    }

    @Override
    public boolean addDataStyle(DataStyle dataStyle) {
        return this.stylesContainer.addDataStyle(dataStyle);
    }

    @Override
    public void setDataStylesMode(Container.Mode mode) {
        this.stylesContainer.setDataStylesMode(mode);
    }

    @Override
    public boolean addMasterPageStyle(MasterPageStyle masterPageStyle) {
        return this.stylesContainer.addMasterPageStyle(masterPageStyle);
    }

    @Override
    public void setMasterPageStyleMode(Container.Mode mode) {
        this.stylesContainer.setMasterPageStyleMode(mode);
    }

    @Override
    public boolean addNewDataStyleFromCellStyle(TableCellStyle style) {
        return this.stylesContainer.addNewDataStyleFromCellStyle(style);
    }

    @Override
    public void setPageLayoutStyleMode(Container.Mode mode) {
        this.stylesContainer.setPageLayoutStyleMode(mode);
    }

    @Override
    public boolean addPageLayoutStyle(PageLayoutStyle pageLayoutStyle) {
        return this.stylesContainer.addPageLayoutStyle(pageLayoutStyle);
    }

    @Override
    public void setPageStyleMode(Container.Mode mode) {
        this.stylesContainer.setPageStyleMode(mode);
    }

    @Override
    public boolean addPageStyle(PageStyle ps) {
        return this.stylesContainer.addPageStyle(ps);
    }

    @Override
    public void setObjectStyleMode(Container.Mode mode) {
        this.stylesContainer.setObjectStyleMode(mode);
    }

    @Override
    public boolean addContentStyle(ObjectStyle objectStyle) {
        return this.stylesContainer.addContentStyle(objectStyle);
    }

    @Override
    public boolean addStylesStyle(ObjectStyle objectStyle) {
        return this.stylesContainer.addStylesStyle(objectStyle);
    }

    @Override
    public TableCellStyle addChildCellStyle(TableCellStyle style, DataStyle dataStyle) {
        return this.stylesContainer.addChildCellStyle(style, dataStyle);
    }

    @Override
    public boolean addContentFontFaceContainerStyle(FontFaceContainerStyle objectStyle) {
        return this.stylesContainer.addContentFontFaceContainerStyle(objectStyle);
    }

    @Override
    public boolean addStylesFontFaceContainerStyle(FontFaceContainerStyle ffcStyle) {
        return this.stylesContainer.addContentFontFaceContainerStyle(ffcStyle);
    }

    public void createEmptyElements(ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing empty ods elements to zip file");
        for (String elementName : EMPTY_ELEMENT_NAMES) {
            this.logger.log(Level.FINEST, "Writing ods element: {0} to zip file", elementName);
            writer.putNextEntry(new ZipEntry(elementName));
            writer.closeEntry();
        }
    }

    public void debugStyles() {
        this.stylesContainer.debug();
    }

    public void freezeStyles() {
        this.stylesContainer.freeze();
    }

    public Table addTableToContent(String name, int rowCapacity, int columnCapacity) throws IOException {
        Table previousTable = this.contentElement.getLastTable();
        Table table = this.contentElement.addTable(name, rowCapacity, columnCapacity);
        this.settingsElement.addTableConfig(table.getConfigEntry());
        if (this.observer != null) {
            this.asyncFlushPreviousTable(previousTable, table);
        }
        return table;
    }

    private void asyncFlushPreviousTable(Table previousTable, Table table) throws IOException {
        table.addObserver(this.observer);
        if (previousTable == null) {
            this.observer.update(new PrepareContentFlusher(this, this.contentElement));
        } else {
            previousTable.asyncFlushEndTable();
        }
    }

    public void prepareAsync() throws IOException {
        this.observer.update(new ImmutableElementsFlusher(this));
    }

    public void saveAsync() throws IOException {
        Table previousTable = this.contentElement.getLastTable();
        if (previousTable == null) {
            this.observer.update(new PrepareContentFlusher(this, this.contentElement));
        } else {
            previousTable.asyncFlushEndTable();
        }
        this.observer.update(new FinalizeFlusher(this.contentElement, this));
    }

    public void writeContent(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: contentElement to zip file");
        this.contentElement.write(xmlUtil, writer);
    }

    public void writeMeta(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: metaElement to zip file");
        this.metaElement.write(xmlUtil, writer);
    }

    public void writeSettings(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.settingsElement.setTables(this.getTables());
        this.logger.log(Level.FINER, "Writing ods element: settingsElement to zip file");
        this.settingsElement.write(xmlUtil, writer);
    }

    public void writeStyles(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: stylesElement to zip file");
        this.stylesElement.write(xmlUtil, writer);
    }

    public void freezeCells(Table table, int rowCount, int colCount) {
        ConfigItemMapEntry tableConfig = table.getConfigEntry();
        tableConfig.put(ConfigItem.create(ConfigElement.HORIZONTAL_SPLIT_MODE, SC_SPLIT_FIX));
        tableConfig.put(ConfigItem.create(ConfigElement.VERTICAL_SPLIT_MODE, SC_SPLIT_FIX));
        tableConfig.put(ConfigItem.create(ConfigElement.HORIZONTAL_SPLIT_POSITION, String.valueOf(rowCount)));
        tableConfig.put(ConfigItem.create(ConfigElement.VERTICAL_SPLIT_POSITION, String.valueOf(colCount)));
    }

    public Table getTable(int tableIndex) {
        return this.contentElement.getTable(tableIndex);
    }

    public Table getTable(String name) {
        return this.contentElement.getTable(name);
    }

    public int getTableCount() {
        return this.contentElement.getTableCount();
    }

    public List<Table> getTables() {
        return this.contentElement.getTables();
    }

    public void setActiveTable(Table table) {
        this.settingsElement.setActiveTable(table);
    }

    public void setViewSetting(String viewId, String item, String value) {
        this.settingsElement.setViewSetting(viewId, item, value);
    }

    public void addAutoFilter(AutoFilter autoFilter) {
        this.contentElement.addAutoFilter(autoFilter);
    }

    public void addExtraFile(String fullPath, String mediaType, CharSequence sequence) {
        ManifestEntry manifestEntry = new ManifestEntry(fullPath, mediaType);
        this.extraFileByName.put(fullPath, sequence);
        this.manifestElement.add(manifestEntry);
    }

    public void addExtraDir(String fullPath) {
        ManifestEntry manifestEntry = new ManifestEntry(fullPath, "");
        this.manifestElement.add(manifestEntry);
    }

    public void writeExtras(ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing extra elements to zip file");
        for (Map.Entry<String, CharSequence> entry : this.extraFileByName.entrySet()) {
            String elementName = entry.getKey();
            this.logger.log(Level.FINEST, "Writing ods element: {0} to zip file", elementName);
            writer.putNextEntry(new ZipEntry(elementName));
            writer.write(entry.getValue());
            writer.closeEntry();
        }
    }

    public void writeMimeType(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: mimeTypeEntry to zip file");
        this.mimeTypeElement.write(xmlUtil, writer);
    }

    public void writeManifest(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: manifestElement to zip file");
        this.manifestElement.write(xmlUtil, writer);
    }

    public void addEvents(ScriptEventListener ... events) {
        this.contentElement.addEvents(events);
    }

    public void addPilotTable(PilotTable pilot) {
        this.contentElement.addPilotTable(pilot);
    }
}

