/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.config.ManifestEntry;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;

public class ManifestElement
implements OdsElement {
    private static final List<ManifestEntry> ENTRIES = Arrays.asList(new ManifestEntry("/", "application/vnd.oasis.opendocument.spreadsheet"), new ManifestEntry("content.xml", "text/xml"), new ManifestEntry("styles.xml", "text/xml"), new ManifestEntry("meta.xml", "text/xml"), new ManifestEntry("settings.xml", "text/xml"), new ManifestEntry("Configurations2/", "application/vnd.sun.xml.ui.configuration"), new ManifestEntry("Configurations2/statusbar/", ""), new ManifestEntry("Configurations2/accelerator/", ""), new ManifestEntry("Configurations2/accelerator/current.xml", ""), new ManifestEntry("Configurations2/floater/", ""), new ManifestEntry("Configurations2/popupmenu/", ""), new ManifestEntry("Configurations2/progressbar/", ""), new ManifestEntry("Configurations2/menubar/", ""), new ManifestEntry("Configurations2/toolbar/", ""), new ManifestEntry("Configurations2/images/", ""), new ManifestEntry("Configurations2/images/Bitmaps/", ""), new ManifestEntry("Thumbnails/", ""), new ManifestEntry("Thumbnails/thumbnail.png", ""));
    private final List<ManifestEntry> manifestEntries;

    public static ManifestElement create() {
        return new ManifestElement(ENTRIES);
    }

    ManifestElement(List<ManifestEntry> initialEntries) {
        this.manifestEntries = new ArrayList<ManifestEntry>(initialEntries);
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putNextEntry(new ZipEntry("META-INF/manifest.xml"));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\">");
        for (ManifestEntry entry : this.manifestEntries) {
            entry.appendXMLContent(util, writer);
        }
        writer.write("</manifest:manifest>");
        writer.flush();
        writer.closeEntry();
    }

    public void add(ManifestEntry manifestEntry) {
        this.manifestEntries.add(manifestEntry);
    }
}

