/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.FloatStyle;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class ScientificNumberStyle
implements DataStyle {
    private final FloatStyle floatStyle;
    private final int minExponentDigits;

    ScientificNumberStyle(FloatStyle floatStyle, int minExponentDigits) {
        this.floatStyle = floatStyle;
        this.minExponentDigits = minExponentDigits;
    }

    private void appendNumber(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<number:scientific-number");
        util.appendAttribute(appendable, (CharSequence)"number:min-exponent-digits", this.minExponentDigits);
        this.floatStyle.appendXMLAttributes(util, appendable);
        appendable.append("/>");
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        StringBuilder number = new StringBuilder();
        this.appendNumber(util, number);
        this.floatStyle.appendXMLHelper(util, appendable, "number-style", number);
    }

    @Override
    public String getName() {
        return this.floatStyle.getName();
    }

    @Override
    public boolean isHidden() {
        return this.floatStyle.isHidden();
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addDataStyle(this);
    }
}

