/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.NumberStyleHelper;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class FractionStyle
implements DataStyle {
    private final NumberStyleHelper numberStyle;
    private final int minDenominatorDigits;
    private final int minNumeratorDigits;

    FractionStyle(NumberStyleHelper numberStyle, int minNumeratorDigits, int minDenominatorDigits) {
        this.numberStyle = numberStyle;
        this.minNumeratorDigits = minNumeratorDigits;
        this.minDenominatorDigits = minDenominatorDigits;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        CharSequence number = this.computeNumberTag(util);
        this.numberStyle.appendXMLHelper(util, appendable, "number-style", number);
    }

    private CharSequence computeNumberTag(XMLUtil util) throws IOException {
        StringBuilder number = new StringBuilder();
        number.append("<number:fraction");
        util.appendAttribute((Appendable)number, (CharSequence)"number:min-numerator-digits", this.minNumeratorDigits);
        util.appendAttribute((Appendable)number, (CharSequence)"number:min-denominator-digits", this.minDenominatorDigits);
        this.numberStyle.appendNumberAttribute(util, number);
        number.append("/>");
        return number;
    }

    @Override
    public String getName() {
        return this.numberStyle.getName();
    }

    @Override
    public boolean isHidden() {
        return this.numberStyle.isHidden();
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addDataStyle(this);
    }
}

