/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.attribute;

import com.github.jferard.fastods.attribute.BorderAttribute;
import com.github.jferard.fastods.attribute.BorderStyle;
import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.attribute.SimpleColor;
import com.github.jferard.fastods.attribute.SimpleLength;

public class BorderAttributeBuilder {
    private Color borderColor;
    private Length borderSize;
    private BorderStyle style = BorderAttribute.DEFAULT_STYLE;

    public BorderAttributeBuilder() {
        this.borderColor = SimpleColor.NONE;
    }

    public BorderAttributeBuilder borderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public BorderAttributeBuilder borderSize(int size) {
        this.borderSize = SimpleLength.pt(size);
        return this;
    }

    public BorderAttributeBuilder borderSize(Length borderSize) {
        this.borderSize = borderSize;
        return this;
    }

    public BorderAttributeBuilder borderStyle(BorderStyle style) {
        this.style = style;
        return this;
    }

    public BorderAttribute build() {
        return new BorderAttribute(this.borderSize, this.borderColor, this.style);
    }
}

