/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.TooltipParameter;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

class TableColdCell {
    private final XMLUtil xmlUtil;
    private int columnsSpanned;
    private String currency;
    private int rowsSpanned;
    private Text text;
    private String tooltip;
    private TooltipParameter tooltipParameter;
    private String formula;
    private int matrixRowsSpanned;
    private int matrixColumnsSpanned;

    public static TableColdCell create(XMLUtil xmlUtil) {
        return new TableColdCell(xmlUtil);
    }

    TableColdCell(XMLUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setColumnsSpanned(int n) {
        this.columnsSpanned = n;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public void setTooltip(String tooltip) {
        String escapedXMLContent = this.xmlUtil.escapeXMLContent(tooltip);
        if (escapedXMLContent.contains("\n")) {
            escapedXMLContent = escapedXMLContent.replaceAll("\r?\n", "</text:p><text:p>");
        }
        this.tooltip = escapedXMLContent;
    }

    public void setTooltip(String tooltip, Length width, Length height, boolean visible) {
        this.setTooltip(tooltip);
        this.tooltipParameter = TooltipParameter.create(width, height, visible);
    }

    public void appendXMLToTable(XMLUtil util, Appendable appendable) throws IOException {
        if (this.formula != null) {
            util.appendEAttribute(appendable, "table:formula", "of:=" + this.formula);
            if (this.matrixRowsSpanned != 0) {
                util.appendAttribute(appendable, (CharSequence)"table:number-matrix-rows-spanned", this.matrixRowsSpanned);
            }
            if (this.matrixColumnsSpanned != 0) {
                util.appendAttribute(appendable, (CharSequence)"table:number-matrix-columns-spanned", this.matrixColumnsSpanned);
            }
        }
        if (!this.isCovered()) {
            if (this.columnsSpanned != 0) {
                util.appendAttribute(appendable, (CharSequence)"table:number-columns-spanned", this.columnsSpanned);
            }
            if (this.rowsSpanned != 0) {
                util.appendAttribute(appendable, (CharSequence)"table:number-rows-spanned", this.rowsSpanned);
            }
        }
        if (this.text == null && this.tooltip == null) {
            appendable.append("/>");
        } else {
            appendable.append(">");
            if (this.text != null) {
                this.text.appendXMLContent(util, appendable);
            }
            if (this.tooltip != null) {
                appendable.append("<office:annotation");
                if (this.tooltipParameter != null) {
                    this.tooltipParameter.appendXMLContent(util, appendable);
                }
                appendable.append("><text:p>").append(this.tooltip).append("</text:p></office:annotation>");
            }
            if (this.isCovered()) {
                appendable.append("</table:covered-table-cell>");
            } else {
                appendable.append("</table:table-cell>");
            }
        }
    }

    public boolean isCovered() {
        return this.columnsSpanned == -1;
    }

    public void setCovered() {
        this.columnsSpanned = -1;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public void setRowsSpanned(int n) {
        this.rowsSpanned = n;
    }

    public void setMatrixRowsSpanned(int n) {
        this.matrixRowsSpanned = n;
    }

    public void setMatrixColumnsSpanned(int n) {
        this.matrixColumnsSpanned = n;
    }
}

