/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.DataWrapper;
import com.github.jferard.fastods.RowCellWalker;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.TableColumn;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.TableRowWalker;
import com.github.jferard.fastods.Text;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableColumnStyle;
import com.github.jferard.fastods.style.TableRowStyle;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class TableCellWalker
implements RowCellWalker,
TableRowWalker,
TableColumn {
    private final Table table;
    private TableRowImpl row;
    private TableCell cell;
    private int r;
    private int c;

    TableCellWalker(Table table) throws IOException {
        this.table = table;
        this.r = 0;
        this.c = 0;
        this.updateShortcuts(table);
    }

    private final void updateShortcuts(Table table) throws IOException {
        this.row = table.getRow(this.r);
        this.cell = this.row.getOrCreateCell(this.c);
    }

    @Override
    public void markRowsSpanned(int n) {
        this.cell.markRowsSpanned(n);
    }

    @Override
    public void setBooleanValue(boolean value) {
        this.cell.setBooleanValue(value);
    }

    @Override
    public void setText(Text text) {
        this.cell.setText(text);
    }

    @Override
    public void setCellMerge(int rowMerge, int columnMerge) throws IOException {
        if (rowMerge < 0 || columnMerge < 0) {
            throw new IllegalArgumentException("row merge and col merge must be >= 0");
        }
        if (rowMerge <= 1 && columnMerge <= 1) {
            return;
        }
        this.table.setCellMerge(this.r, this.c, rowMerge, columnMerge);
    }

    @Override
    public void setColumnsSpanned(int n) {
        this.row.setColumnsSpanned(this.c, n);
    }

    @Override
    public void markColumnsSpanned(int n) {
        this.cell.markColumnsSpanned(n);
    }

    @Override
    public void setDateValue(Date value) {
        this.cell.setDateValue(value);
    }

    @Override
    public void setFloatValue(Number value) {
        this.cell.setFloatValue(value);
    }

    @Override
    public void setPercentageValue(Number value) {
        this.cell.setPercentageValue(value);
    }

    @Override
    public void setRowsSpanned(int n) throws IOException {
        this.row.setRowsSpanned(this.c, n);
    }

    @Override
    public void setVoidValue() {
        this.cell.setVoidValue();
    }

    @Override
    public void setMatrixFormula(String formula) {
        this.cell.setMatrixFormula(formula);
    }

    @Override
    public void setMatrixFormula(String formula, int matrixRowsSpanned, int matrixColumnsSpanned) {
        this.cell.setMatrixFormula(formula, matrixRowsSpanned, matrixColumnsSpanned);
    }

    @Override
    public void setStringValue(String value) {
        this.cell.setStringValue(value);
    }

    @Override
    public void setTimeValue(long timeInMillis) {
        this.cell.setTimeValue(timeInMillis);
    }

    @Override
    public void setTimeValue(long years, long months, long days, long hours, long minutes, double seconds) {
        this.cell.setTimeValue(years, months, days, hours, minutes, seconds);
    }

    @Override
    public void setNegTimeValue(long years, long months, long days, long hours, long minutes, double seconds) {
        this.cell.setNegTimeValue(years, months, days, hours, minutes, seconds);
    }

    @Override
    public void setTooltip(String tooltip) {
        this.cell.setTooltip(tooltip);
    }

    @Override
    public void setTooltip(String tooltip, Length width, Length height, boolean visible) {
        this.cell.setTooltip(tooltip, width, height, visible);
    }

    @Override
    public void setFormula(String formula) {
        this.cell.setFormula(formula);
    }

    @Override
    public boolean hasValue() {
        return this.cell.hasValue();
    }

    @Override
    public boolean isCovered() {
        return this.cell.isCovered();
    }

    @Override
    public void setCovered() {
        this.cell.setCovered();
    }

    @Override
    public void setCellValue(CellValue value) {
        this.cell.setCellValue(value);
    }

    @Override
    public void setCurrencyValue(float value, String currency) {
        this.cell.setCurrencyValue(value, currency);
    }

    @Override
    public void setCurrencyValue(int value, String currency) {
        this.cell.setCurrencyValue(value, currency);
    }

    @Override
    public void setCurrencyValue(Number value, String currency) {
        this.cell.setCurrencyValue(value, currency);
    }

    @Override
    public void setDateValue(Calendar cal) {
        this.cell.setDateValue(cal);
    }

    @Override
    public void setFloatValue(float value) {
        this.cell.setFloatValue(value);
    }

    @Override
    public void setFloatValue(int value) {
        this.cell.setFloatValue(value);
    }

    @Override
    public void setPercentageValue(float value) {
        this.cell.setPercentageValue(value);
    }

    @Override
    public void setPercentageValue(int value) {
        this.cell.setPercentageValue(value);
    }

    @Override
    public void setStyle(TableCellStyle style) {
        this.cell.setStyle(style);
    }

    @Override
    public void setDataStyle(DataStyle dataStyle) {
        this.cell.setDataStyle(dataStyle);
    }

    @Override
    public void setColumnStyle(TableColumnStyle columnStyle) {
        this.table.setColumnStyle(this.c, columnStyle);
    }

    @Override
    public void setRowFormat(DataStyles format) {
        this.row.setRowFormat(format);
    }

    @Override
    public void setRowStyle(TableRowStyle rowStyle) {
        this.row.setRowStyle(rowStyle);
    }

    @Override
    public int getColumnCount() {
        return this.row.getColumnCount();
    }

    @Override
    public void setDefaultCellStyle(TableCellStyle ts) {
        this.row.setDefaultCellStyle(ts);
    }

    @Override
    public int rowIndex() {
        return this.r;
    }

    @Override
    public int colIndex() {
        return this.c;
    }

    @Override
    public void removeRowStyle() {
        this.row.removeRowStyle();
    }

    @Override
    public boolean hasNext() {
        return this.c < this.row.getColumnCount();
    }

    @Override
    public boolean hasPrevious() {
        return this.c > 0 && this.c <= this.row.getColumnCount();
    }

    @Override
    public void last() {
        this.c = this.row.getColumnCount() - 1;
        this.cell = this.row.getOrCreateCell(this.c);
    }

    @Override
    public void next() {
        ++this.c;
        this.cell = this.row.getOrCreateCell(this.c);
    }

    @Override
    public void previous() {
        if (this.c <= 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.c;
        this.cell = this.row.getOrCreateCell(this.c);
    }

    @Override
    public void to(int c) {
        if (c < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.c = c;
        this.cell = this.row.getOrCreateCell(this.c);
    }

    @Override
    public boolean hasNextRow() {
        return this.r < this.table.getRowCount();
    }

    @Override
    public boolean hasPreviousRow() {
        return this.r > 0 && this.r <= this.table.getRowCount();
    }

    @Override
    public void lastRow() throws IOException {
        this.r = this.table.getRowCount() - 1;
        this.c = 0;
        this.updateShortcuts(this.table);
    }

    @Override
    public void nextRow() throws IOException {
        ++this.r;
        this.c = 0;
        this.updateShortcuts(this.table);
    }

    @Override
    public void previousRow() throws IOException {
        if (this.r <= 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.r;
        this.c = 0;
        this.updateShortcuts(this.table);
    }

    @Override
    public void toRow(int r) throws IOException {
        if (r < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.r = r;
        this.c = 0;
        this.updateShortcuts(this.table);
    }

    public Table getTable() {
        return this.table;
    }

    public void addData(DataWrapper data) throws IOException {
        data.addToTable(this);
    }
}

