/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.NamedOdsDocument;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsAsyncFlusher;
import com.github.jferard.fastods.OdsFileWriterBuilder;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.logging.Logger;

public class OdsFileDirectWriter
implements NamedOdsFileWriter {
    private final NamedOdsDocument document;
    private final Logger logger;
    private final ZipUTF8Writer writer;
    private final XMLUtil xmlUtil;

    public static OdsFileWriterBuilder builder(Logger logger, NamedOdsDocument document) {
        return new OdsFileWriterBuilder(logger, document);
    }

    OdsFileDirectWriter(Logger logger, XMLUtil xmlUtil, NamedOdsDocument document, ZipUTF8Writer writer) {
        this.logger = logger;
        this.document = document;
        this.xmlUtil = xmlUtil;
        this.writer = writer;
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @Override
    public NamedOdsDocument document() {
        return this.document;
    }

    @Override
    public void save() throws IOException {
        this.document.save();
    }

    @Override
    public void update(OdsAsyncFlusher flusher) throws IOException {
        flusher.flushInto(this.xmlUtil, this.writer);
    }
}

