/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Link;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.ref.TableRef;
import com.github.jferard.fastods.style.TextStyle;
import java.io.File;
import java.net.URI;
import java.net.URL;

public class LinkBuilder {
    private final String text;
    private TextStyle textStyle;
    private String href;

    public LinkBuilder(String text) {
        this.text = text;
    }

    public Link build() {
        return new Link(this.text, this.textStyle, this.href);
    }

    public LinkBuilder style(TextStyle ts) {
        this.textStyle = ts;
        return this;
    }

    public LinkBuilder to(Table table) {
        this.href = '#' + table.getName();
        return this;
    }

    public LinkBuilder to(TableRef tableRef) {
        this.href = tableRef.toString();
        return this;
    }

    public LinkBuilder to(String relativeRef) {
        this.href = relativeRef;
        return this;
    }

    public LinkBuilder to(File file) {
        this.href = file.toURI().toString();
        return this;
    }

    public LinkBuilder to(URL url) {
        this.href = url.toString();
        return this;
    }

    public LinkBuilder to(URI uri) {
        this.href = uri.toString();
        return this;
    }
}

