/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.king.camera.scan.FrameMetadata;
import com.king.camera.scan.util.BitmapUtils;

public class AnalyzeResult<T> {
    private final byte[] imageData;
    private final int imageFormat;
    private final FrameMetadata frameMetadata;
    private Bitmap bitmap;
    private final T result;

    public AnalyzeResult(@NonNull byte[] imageData, int imageFormat, @NonNull FrameMetadata frameMetadata, @NonNull T result) {
        this.imageData = imageData;
        this.imageFormat = imageFormat;
        this.frameMetadata = frameMetadata;
        this.result = result;
    }

    @NonNull
    public byte[] getImageData() {
        return this.imageData;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    @NonNull
    public FrameMetadata getFrameMetadata() {
        return this.frameMetadata;
    }

    @Nullable
    public Bitmap getBitmap() {
        if (this.imageFormat != 17) {
            throw new IllegalArgumentException("only support ImageFormat.NV21 for now.");
        }
        if (this.bitmap == null) {
            this.bitmap = BitmapUtils.getBitmap(this.imageData, this.frameMetadata);
        }
        return this.bitmap;
    }

    @Deprecated
    public int getBitmapWidth() {
        return this.getImageWidth();
    }

    public int getImageWidth() {
        if (this.frameMetadata.getRotation() % 180 == 0) {
            return this.frameMetadata.getWidth();
        }
        return this.frameMetadata.getHeight();
    }

    @Deprecated
    public int getBitmapHeight() {
        return this.getImageHeight();
    }

    public int getImageHeight() {
        if (this.frameMetadata.getRotation() % 180 == 0) {
            return this.frameMetadata.getHeight();
        }
        return this.frameMetadata.getWidth();
    }

    @NonNull
    public T getResult() {
        return this.result;
    }
}

