/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.king.camera.scan.AnalyzeResult;
import com.king.camera.scan.ICamera;
import com.king.camera.scan.ICameraControl;
import com.king.camera.scan.analyze.Analyzer;
import com.king.camera.scan.config.CameraConfig;

public abstract class CameraScan<T>
implements ICamera,
ICameraControl {
    public static String SCAN_RESULT = "SCAN_RESULT";
    public static int LENS_FACING_FRONT = 0;
    public static int LENS_FACING_BACK = 1;
    public static final float ASPECT_RATIO_4_3 = 1.3333334f;
    public static final float ASPECT_RATIO_16_9 = 1.7777778f;
    private boolean isNeedTouchZoom = true;
    protected Bundle mExtras;

    protected boolean isNeedTouchZoom() {
        return this.isNeedTouchZoom;
    }

    public CameraScan<T> setNeedTouchZoom(boolean needTouchZoom) {
        this.isNeedTouchZoom = needTouchZoom;
        return this;
    }

    @NonNull
    public Bundle getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    public abstract CameraScan<T> setCameraConfig(CameraConfig var1);

    public abstract CameraScan<T> setAnalyzeImage(boolean var1);

    public abstract CameraScan<T> setAutoStopAnalyze(boolean var1);

    public abstract CameraScan<T> setAnalyzer(Analyzer<T> var1);

    public abstract CameraScan<T> setVibrate(boolean var1);

    public abstract CameraScan<T> setPlayBeep(boolean var1);

    public abstract CameraScan<T> setOnScanResultCallback(OnScanResultCallback<T> var1);

    public abstract CameraScan<T> bindFlashlightView(@Nullable View var1);

    public abstract CameraScan<T> setDarkLightLux(float var1);

    public abstract CameraScan<T> setBrightLightLux(float var1);

    @Nullable
    public static String parseScanResult(Intent data) {
        if (data != null) {
            return data.getStringExtra(SCAN_RESULT);
        }
        return null;
    }

    public static interface OnScanResultCallback<T> {
        public void onScanResultCallback(@NonNull AnalyzeResult<T> var1);

        default public void onScanResultFailure() {
        }
    }
}

