/*
 * Decompiled with CFR 0.152.
 */
package com.king.camera.scan.util;

import android.util.Log;
import java.util.Locale;

public class LogUtils {
    public static final String TAG = "CameraScan";
    public static final String VERTICAL = "|";
    private static boolean isShowLog = true;
    private static int priority = 1;
    public static final int PRINTLN = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public static final String TAG_FORMAT = "%s.%s(%s:%d)";

    private LogUtils() {
        throw new AssertionError();
    }

    public static void setShowLog(boolean isShowLog) {
        LogUtils.isShowLog = isShowLog;
    }

    public static boolean isShowLog() {
        return isShowLog;
    }

    public static int getPriority() {
        return priority;
    }

    public static void setPriority(int priority) {
        LogUtils.priority = priority;
    }

    private static String generateTag(StackTraceElement caller) {
        String tag = TAG_FORMAT;
        String callerClazzName = caller.getClassName();
        callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
        tag = String.format(Locale.getDefault(), tag, callerClazzName, caller.getMethodName(), caller.getFileName(), caller.getLineNumber());
        return TAG + VERTICAL + tag;
    }

    public static StackTraceElement getStackTraceElement(int n) {
        return Thread.currentThread().getStackTrace()[n];
    }

    private static String getCallerStackLogTag() {
        return LogUtils.generateTag(LogUtils.getStackTraceElement(5));
    }

    private static String getStackTraceString(Throwable t) {
        return Log.getStackTraceString((Throwable)t);
    }

    public static void v(String msg) {
        if (isShowLog && priority <= 2) {
            Log.v((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg));
        }
    }

    public static void v(Throwable t) {
        if (isShowLog && priority <= 2) {
            Log.v((String)LogUtils.getCallerStackLogTag(), (String)LogUtils.getStackTraceString(t));
        }
    }

    public static void v(String msg, Throwable t) {
        if (isShowLog && priority <= 2) {
            Log.v((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg), (Throwable)t);
        }
    }

    public static void d(String msg) {
        if (isShowLog && priority <= 3) {
            Log.d((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg));
        }
    }

    public static void d(Throwable t) {
        if (isShowLog && priority <= 3) {
            Log.d((String)LogUtils.getCallerStackLogTag(), (String)LogUtils.getStackTraceString(t));
        }
    }

    public static void d(String msg, Throwable t) {
        if (isShowLog && priority <= 3) {
            Log.d((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg), (Throwable)t);
        }
    }

    public static void i(String msg) {
        if (isShowLog && priority <= 4) {
            Log.i((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg));
        }
    }

    public static void i(Throwable t) {
        if (isShowLog && priority <= 4) {
            Log.i((String)LogUtils.getCallerStackLogTag(), (String)LogUtils.getStackTraceString(t));
        }
    }

    public static void i(String msg, Throwable t) {
        if (isShowLog && priority <= 4) {
            Log.i((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg), (Throwable)t);
        }
    }

    public static void w(String msg) {
        if (isShowLog && priority <= 5) {
            Log.w((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg));
        }
    }

    public static void w(Throwable t) {
        if (isShowLog && priority <= 5) {
            Log.w((String)LogUtils.getCallerStackLogTag(), (String)LogUtils.getStackTraceString(t));
        }
    }

    public static void w(String msg, Throwable t) {
        if (isShowLog && priority <= 5) {
            Log.w((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg), (Throwable)t);
        }
    }

    public static void e(String msg) {
        if (isShowLog && priority <= 6) {
            Log.e((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg));
        }
    }

    public static void e(Throwable t) {
        if (isShowLog && priority <= 6) {
            Log.e((String)LogUtils.getCallerStackLogTag(), (String)LogUtils.getStackTraceString(t));
        }
    }

    public static void e(String msg, Throwable t) {
        if (isShowLog && priority <= 6) {
            Log.e((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg), (Throwable)t);
        }
    }

    public static void wtf(String msg) {
        if (isShowLog && priority <= 7) {
            Log.wtf((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg));
        }
    }

    public static void wtf(Throwable t) {
        if (isShowLog && priority <= 7) {
            Log.wtf((String)LogUtils.getCallerStackLogTag(), (String)LogUtils.getStackTraceString(t));
        }
    }

    public static void wtf(String msg, Throwable t) {
        if (isShowLog && priority <= 7) {
            Log.wtf((String)LogUtils.getCallerStackLogTag(), (String)String.valueOf(msg), (Throwable)t);
        }
    }

    public static void print(String msg) {
        if (isShowLog && priority <= 1) {
            System.out.print(msg);
        }
    }

    public static void print(Object obj) {
        if (isShowLog && priority <= 1) {
            System.out.print(obj);
        }
    }

    public static void printf(String msg) {
        if (isShowLog && priority <= 1) {
            System.out.printf(msg, new Object[0]);
        }
    }

    public static void println(String msg) {
        if (isShowLog && priority <= 1) {
            System.out.println(msg);
        }
    }

    public static void println(Object obj) {
        if (isShowLog && priority <= 1) {
            System.out.println(obj);
        }
    }
}

