/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.github.jcustenborder.kafka.connect.utils.config.Description;
import com.github.jcustenborder.kafka.connect.utils.config.ValidHostnameAndPort;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import java.io.File;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;

public class ConfigUtils {
    public static <T extends Enum<T>> T getEnum(Class<T> enumClass, AbstractConfig config, String key) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        String textValue = config.getString(key);
        return Enum.valueOf(enumClass, textValue);
    }

    public static <T extends Enum<T>> List<T> getEnums(Class<T> enumClass, AbstractConfig config, String key) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        Preconditions.checkState((ConfigDef.Type.LIST == config.typeOf(key) ? 1 : 0) != 0, (String)"'%s' must be a list", (Object)key);
        ArrayList<T> result = new ArrayList<T>();
        List values = config.getList(key);
        for (String value : values) {
            result.add(Enum.valueOf(enumClass, value));
        }
        return result;
    }

    public static <T extends Enum<T>> String enumDescription(Class<T> enumClass, T ... excludes) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        ImmutableSet exclude = ImmutableSet.copyOf((Object[])excludes);
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        Map descriptions = Stream.of(constants).filter(arg_0 -> ConfigUtils.lambda$enumDescription$0((Set)exclude, arg_0)).sorted(Comparator.comparing(Enum::name)).collect(Collectors.toMap(Function.identity(), enumConstant -> {
            try {
                Field enumField = enumClass.getField(enumConstant.name());
                Description descriptionAttribute = enumField.getAnnotation(Description.class);
                String description = null != descriptionAttribute ? descriptionAttribute.value() : null;
                return description;
            }
            catch (NoSuchFieldException ex) {
                throw new IllegalStateException("Could not find field " + enumConstant.name(), ex);
            }
        }, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        return ConfigUtils.enumDescription(descriptions);
    }

    public static <T extends Enum<T>> String enumDescription(Map<T, String> descriptions) {
        StringBuilder builder = new StringBuilder();
        descriptions.forEach((key, value) -> {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append('`');
            builder.append(key.toString());
            builder.append("` - ");
            builder.append((String)value);
        });
        return builder.toString();
    }

    public static String enumValues(Class<?> enumClass) {
        Preconditions.checkNotNull(enumClass, (Object)"enumClass cannot be null");
        Preconditions.checkState((boolean)enumClass.isEnum(), (Object)"enumClass must be an enum.");
        return Joiner.on((String)", ").join((Object[])enumClass.getEnumConstants());
    }

    public static File getAbsoluteFile(AbstractConfig config, String key) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        String path = config.getString(key);
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new ConfigException(key, (Object)path, "Must be an absolute path.");
        }
        return new File(path);
    }

    static InetSocketAddress parseInetSocketAddress(String s) {
        Preconditions.checkNotNull((Object)s, (Object)"s cannot be null.");
        Matcher matcher = ValidHostnameAndPort.HOSTNAME_PATTERN.matcher(s);
        Preconditions.checkState((boolean)matcher.matches(), (String)"'%s' does not match '%s'", (Object)s, (Object)ValidHostnameAndPort.HOSTNAME_PATTERN.pattern());
        Integer port = Ints.tryParse((String)matcher.group(2));
        Preconditions.checkState((port >= 1 && port <= 65535 ? 1 : 0) != 0, (String)"Invalid port value %s. Must be between 1 and 65535", (Object)port);
        return new InetSocketAddress(matcher.group(1), (int)port);
    }

    public static InetSocketAddress inetSocketAddress(AbstractConfig config, String key) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        String value = config.getString(key);
        return ConfigUtils.parseInetSocketAddress(value);
    }

    public static List<InetSocketAddress> inetSocketAddresses(AbstractConfig config, String key) {
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        List value = config.getList(key);
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(value.size());
        for (String s : value) {
            addresses.add(ConfigUtils.parseInetSocketAddress(s));
        }
        return ImmutableList.copyOf(addresses);
    }

    static HostAndPort hostAndPort(String input, Integer defaultPort) {
        HostAndPort result = HostAndPort.fromString((String)input);
        if (null != defaultPort) {
            result = result.withDefaultPort(defaultPort.intValue());
        }
        return result;
    }

    public static HostAndPort hostAndPort(AbstractConfig config, String key, Integer defaultPort) {
        String input = config.getString(key);
        return ConfigUtils.hostAndPort(input, defaultPort);
    }

    public static HostAndPort hostAndPort(AbstractConfig config, String key) {
        return ConfigUtils.hostAndPort(config, key, null);
    }

    public static List<HostAndPort> hostAndPorts(AbstractConfig config, String key, Integer defaultPort) {
        List inputs = config.getList(key);
        ArrayList<HostAndPort> result = new ArrayList<HostAndPort>();
        for (String input : inputs) {
            HostAndPort hostAndPort = ConfigUtils.hostAndPort(input, defaultPort);
            result.add(hostAndPort);
        }
        return ImmutableList.copyOf(result);
    }

    public static List<HostAndPort> hostAndPorts(AbstractConfig config, String key) {
        return ConfigUtils.hostAndPorts(config, key, null);
    }

    static URL url(String key, String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            ConfigException configException = new ConfigException(key, (Object)value, "Could not parse to URL.");
            configException.initCause((Throwable)e);
            throw configException;
        }
    }

    public static URL url(AbstractConfig config, String key) {
        String value = config.getString(key);
        return ConfigUtils.url(key, value);
    }

    public static List<URL> urls(AbstractConfig config, String key) {
        ArrayList<URL> result = new ArrayList<URL>();
        List input = config.getList(key);
        for (String s : input) {
            result.add(ConfigUtils.url(key, s));
        }
        return ImmutableList.copyOf(result);
    }

    static URI uri(String key, String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            ConfigException configException = new ConfigException(key, (Object)value, "Could not parse to URI.");
            configException.initCause((Throwable)e);
            throw configException;
        }
    }

    public static URI uri(AbstractConfig config, String key) {
        String value = config.getString(key);
        return ConfigUtils.uri(key, value);
    }

    public static List<URI> uris(AbstractConfig config, String key) {
        ArrayList<URI> result = new ArrayList<URI>();
        List input = config.getList(key);
        for (String s : input) {
            result.add(ConfigUtils.uri(key, s));
        }
        return ImmutableList.copyOf(result);
    }

    public static Set<String> getSet(AbstractConfig config, String key) {
        List value = config.getList(key);
        return ImmutableSet.copyOf((Collection)value);
    }

    public static Pattern pattern(AbstractConfig config, String key) {
        String pattern = config.getString(key);
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigException(key, (Object)pattern, String.format("Could not compile regex '%s'.", pattern));
        }
    }

    public static byte[] passwordBytes(AbstractConfig config, String key) {
        return ConfigUtils.passwordBytes(config, key, Charsets.UTF_8);
    }

    public static byte[] passwordBytes(AbstractConfig config, String key, String charset) {
        return ConfigUtils.passwordBytes(config, key, Charset.forName(charset));
    }

    public static byte[] passwordBytes(AbstractConfig config, String key, Charset charset) {
        Password password = config.getPassword(key);
        return password.value().getBytes(charset);
    }

    public static char[] passwordCharArray(AbstractConfig config, String key) {
        Password password = config.getPassword(key);
        return password.value().toCharArray();
    }

    public static KeyStore keyStore(AbstractConfig config, String key) {
        String keyStoreType = config.getString(key);
        try {
            return KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            ConfigException exception = new ConfigException(key, (Object)keyStoreType, "Invalid KeyStore type.");
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    public static KeyManagerFactory keyManagerFactory(AbstractConfig config, String key) {
        String keyManagerFactoryType = config.getString(key);
        try {
            return KeyManagerFactory.getInstance(keyManagerFactoryType);
        }
        catch (NoSuchAlgorithmException e) {
            ConfigException exception = new ConfigException(key, (Object)keyManagerFactoryType, "Unknown Algorithm.");
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    public static TrustManagerFactory trustManagerFactory(AbstractConfig config, String key) {
        String trustManagerFactoryType = config.getString(key);
        try {
            return TrustManagerFactory.getInstance(trustManagerFactoryType);
        }
        catch (NoSuchAlgorithmException e) {
            ConfigException exception = new ConfigException(key, (Object)trustManagerFactoryType, "Unknown Algorithm.");
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    public static SSLContext sslContext(AbstractConfig config, String key) {
        String trustManagerFactoryType = config.getString(key);
        try {
            return SSLContext.getInstance(trustManagerFactoryType);
        }
        catch (NoSuchAlgorithmException e) {
            ConfigException exception = new ConfigException(key, (Object)trustManagerFactoryType, "Unknown Algorithm.");
            exception.initCause((Throwable)e);
            throw exception;
        }
    }

    public static Charset charset(AbstractConfig config, String key) {
        String charsetName = config.getString(key);
        try {
            return Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException ex) {
            ConfigException exception = new ConfigException(key, (Object)charsetName, "Invalid charset.");
            exception.initCause((Throwable)ex);
            throw exception;
        }
    }

    public static List<Charset> charsets(AbstractConfig config, String key) {
        List charsetNames = config.getList(key);
        ArrayList<Charset> result = new ArrayList<Charset>(charsetNames.size());
        for (String charsetName : charsetNames) {
            try {
                Charset charset = Charset.forName(charsetName);
                result.add(charset);
            }
            catch (UnsupportedCharsetException ex) {
                ConfigException exception = new ConfigException(key, (Object)charsetName, "Invalid charset.");
                exception.initCause((Throwable)ex);
                throw exception;
            }
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$enumDescription$0(Set exclude, Enum e) {
        return !exclude.contains(e);
    }
}

