/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.connect.data.Schema;
import org.immutables.value.Generated;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.SchemaInput", generator="Immutables")
@Immutable
public final class ImmutableSchemaInput
implements Plugin.SchemaInput {
    @Nullable
    private final String name;
    @Nullable
    private final transient String schemaLink;
    @Nullable
    private final transient String shortName;
    @Nullable
    private final String doc;
    private final boolean isOptional;
    private final Schema.Type type;
    @Nullable
    private final String fieldName;
    @Nullable
    private final ImmutableList<Plugin.SchemaInput> fields;
    @Nullable
    private final Plugin.SchemaInput key;
    @Nullable
    private final Plugin.SchemaInput value;
    private final transient String refLink;
    private final transient String table;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSchemaInput(@Nullable String name, @Nullable String doc, boolean isOptional, Schema.Type type, @Nullable String fieldName, @Nullable ImmutableList<Plugin.SchemaInput> fields, @Nullable Plugin.SchemaInput key, @Nullable Plugin.SchemaInput value) {
        this.name = name;
        this.doc = doc;
        this.isOptional = isOptional;
        this.type = type;
        this.fieldName = fieldName;
        this.fields = fields;
        this.key = key;
        this.value = value;
        this.schemaLink = this.initShim.getSchemaLink();
        this.shortName = this.initShim.getShortName();
        this.refLink = this.initShim.getRefLink();
        this.table = this.initShim.getTable();
        this.initShim = null;
    }

    @Nullable
    private String getSchemaLinkInitialize() {
        return Plugin.SchemaInput.super.getSchemaLink();
    }

    @Nullable
    private String getShortNameInitialize() {
        return Plugin.SchemaInput.super.getShortName();
    }

    private String getRefLinkInitialize() {
        return Plugin.SchemaInput.super.getRefLink();
    }

    private String getTableInitialize() {
        return Plugin.SchemaInput.super.getTable();
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getSchemaLink() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaLink() : this.schemaLink;
    }

    @Override
    @Nullable
    public String getShortName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getShortName() : this.shortName;
    }

    @Override
    @Nullable
    public String getDoc() {
        return this.doc;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public Schema.Type getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    public ImmutableList<Plugin.SchemaInput> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public Plugin.SchemaInput key() {
        return this.key;
    }

    @Override
    @Nullable
    public Plugin.SchemaInput value() {
        return this.value;
    }

    @Override
    public String getRefLink() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRefLink() : this.refLink;
    }

    @Override
    public String getTable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTable() : this.table;
    }

    public final ImmutableSchemaInput withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableSchemaInput(value, this.doc, this.isOptional, this.type, this.fieldName, this.fields, this.key, this.value);
    }

    public final ImmutableSchemaInput withDoc(@Nullable String value) {
        if (Objects.equals(this.doc, value)) {
            return this;
        }
        return new ImmutableSchemaInput(this.name, value, this.isOptional, this.type, this.fieldName, this.fields, this.key, this.value);
    }

    public final ImmutableSchemaInput withIsOptional(boolean value) {
        if (this.isOptional == value) {
            return this;
        }
        return new ImmutableSchemaInput(this.name, this.doc, value, this.type, this.fieldName, this.fields, this.key, this.value);
    }

    public final ImmutableSchemaInput withType(Schema.Type value) {
        if (this.type == value) {
            return this;
        }
        Schema.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, newValue, this.fieldName, this.fields, this.key, this.value);
    }

    public final ImmutableSchemaInput withFieldName(@Nullable String value) {
        if (Objects.equals(this.fieldName, value)) {
            return this;
        }
        return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, value, this.fields, this.key, this.value);
    }

    public final ImmutableSchemaInput withFields(Plugin.SchemaInput ... elements) {
        if (elements == null) {
            return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, null, this.key, this.value);
        }
        ImmutableList<Plugin.SchemaInput> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, newValue, this.key, this.value);
    }

    public final ImmutableSchemaInput withFields(@Nullable Iterable<? extends Plugin.SchemaInput> elements) {
        if (this.fields == elements) {
            return this;
        }
        ImmutableList<Plugin.SchemaInput> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, newValue, this.key, this.value);
    }

    public final ImmutableSchemaInput withKey(@Nullable Plugin.SchemaInput value) {
        if (this.key == value) {
            return this;
        }
        return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, this.fields, value, this.value);
    }

    public final ImmutableSchemaInput withValue(@Nullable Plugin.SchemaInput value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, this.fields, this.key, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSchemaInput && this.equalTo((ImmutableSchemaInput)another);
    }

    private boolean equalTo(ImmutableSchemaInput another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.schemaLink, another.schemaLink) && Objects.equals(this.shortName, another.shortName) && Objects.equals(this.doc, another.doc) && this.isOptional == another.isOptional && this.type.equals((Object)another.type) && Objects.equals(this.fieldName, another.fieldName) && Objects.equals(this.fields, another.fields) && Objects.equals(this.key, another.key) && Objects.equals(this.value, another.value) && this.refLink.equals(another.refLink) && this.table.equals(another.table);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.name);
        h2 += (h2 << 5) + Objects.hashCode(this.schemaLink);
        h2 += (h2 << 5) + Objects.hashCode(this.shortName);
        h2 += (h2 << 5) + Objects.hashCode(this.doc);
        h2 += (h2 << 5) + Booleans.hashCode(this.isOptional);
        h2 += (h2 << 5) + this.type.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.fieldName);
        h2 += (h2 << 5) + Objects.hashCode(this.fields);
        h2 += (h2 << 5) + Objects.hashCode(this.key);
        h2 += (h2 << 5) + Objects.hashCode(this.value);
        h2 += (h2 << 5) + this.refLink.hashCode();
        h2 += (h2 << 5) + this.table.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SchemaInput").omitNullValues().add("name", this.name).add("schemaLink", this.schemaLink).add("shortName", this.shortName).add("doc", this.doc).add("isOptional", this.isOptional).add("type", this.type).add("fieldName", this.fieldName).add("fields", this.fields).add("key", this.key).add("value", this.value).add("refLink", this.refLink).add("table", this.table).toString();
    }

    public static ImmutableSchemaInput copyOf(Plugin.SchemaInput instance) {
        if (instance instanceof ImmutableSchemaInput) {
            return (ImmutableSchemaInput)instance;
        }
        return ImmutableSchemaInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.SchemaInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_OPTIONAL = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private String doc;
        private boolean isOptional;
        @Nullable
        private Schema.Type type;
        @Nullable
        private String fieldName;
        private ImmutableList.Builder<Plugin.SchemaInput> fields = null;
        @Nullable
        private Plugin.SchemaInput key;
        @Nullable
        private Plugin.SchemaInput value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.SchemaInput instance) {
            Plugin.SchemaInput valueValue;
            Plugin.SchemaInput keyValue;
            List<Plugin.SchemaInput> fieldsValue;
            String docValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.getName();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((docValue = instance.getDoc()) != null) {
                this.doc(docValue);
            }
            this.isOptional(instance.isOptional());
            this.type(instance.getType());
            String fieldNameValue = instance.getFieldName();
            if (fieldNameValue != null) {
                this.fieldName(fieldNameValue);
            }
            if ((fieldsValue = instance.getFields()) != null) {
                this.addAllFields(fieldsValue);
            }
            if ((keyValue = instance.key()) != null) {
                this.key(keyValue);
            }
            if ((valueValue = instance.value()) != null) {
                this.value(valueValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder doc(@Nullable String doc) {
            this.doc = doc;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isOptional(boolean isOptional) {
            this.isOptional = isOptional;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(Schema.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fieldName(@Nullable String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(Plugin.SchemaInput element) {
            if (this.fields == null) {
                this.fields = ImmutableList.builder();
            }
            this.fields.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(Plugin.SchemaInput ... elements) {
            if (this.fields == null) {
                this.fields = ImmutableList.builder();
            }
            this.fields.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fields(@Nullable Iterable<? extends Plugin.SchemaInput> elements) {
            if (elements == null) {
                this.fields = null;
                return this;
            }
            this.fields = ImmutableList.builder();
            return this.addAllFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFields(Iterable<? extends Plugin.SchemaInput> elements) {
            Objects.requireNonNull(elements, "fields element");
            if (this.fields == null) {
                this.fields = ImmutableList.builder();
            }
            this.fields.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(@Nullable Plugin.SchemaInput key) {
            this.key = key;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(@Nullable Plugin.SchemaInput value) {
            this.value = value;
            return this;
        }

        public ImmutableSchemaInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSchemaInput(this.name, this.doc, this.isOptional, this.type, this.fieldName, (ImmutableList)(this.fields == null ? null : this.fields.build()), this.key, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isOptional");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build SchemaInput, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Plugin.SchemaInput", generator="Immutables")
    private final class InitShim {
        private byte schemaLinkBuildStage = 0;
        private String schemaLink;
        private byte shortNameBuildStage = 0;
        private String shortName;
        private byte refLinkBuildStage = 0;
        private String refLink;
        private byte tableBuildStage = 0;
        private String table;

        private InitShim() {
        }

        String getSchemaLink() {
            if (this.schemaLinkBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaLinkBuildStage == 0) {
                this.schemaLinkBuildStage = (byte)-1;
                this.schemaLink = ImmutableSchemaInput.this.getSchemaLinkInitialize();
                this.schemaLinkBuildStage = 1;
            }
            return this.schemaLink;
        }

        String getShortName() {
            if (this.shortNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.shortNameBuildStage == 0) {
                this.shortNameBuildStage = (byte)-1;
                this.shortName = ImmutableSchemaInput.this.getShortNameInitialize();
                this.shortNameBuildStage = 1;
            }
            return this.shortName;
        }

        String getRefLink() {
            if (this.refLinkBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.refLinkBuildStage == 0) {
                this.refLinkBuildStage = (byte)-1;
                this.refLink = Objects.requireNonNull(ImmutableSchemaInput.this.getRefLinkInitialize(), "refLink");
                this.refLinkBuildStage = 1;
            }
            return this.refLink;
        }

        String getTable() {
            if (this.tableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tableBuildStage == 0) {
                this.tableBuildStage = (byte)-1;
                this.table = Objects.requireNonNull(ImmutableSchemaInput.this.getTableInitialize(), "table");
                this.tableBuildStage = 1;
            }
            return this.table;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.schemaLinkBuildStage == -1) {
                attributes.add("schemaLink");
            }
            if (this.shortNameBuildStage == -1) {
                attributes.add("shortName");
            }
            if (this.refLinkBuildStage == -1) {
                attributes.add("refLink");
            }
            if (this.tableBuildStage == -1) {
                attributes.add("table");
            }
            return "Cannot build SchemaInput, attribute initializers form cycle " + attributes;
        }
    }
}

