/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.common.config.ConfigDef;
import org.immutables.value.Generated;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.Item", generator="Immutables")
@Immutable
public final class ImmutableItem
implements Plugin.Item {
    private final String name;
    private final ConfigDef.Importance importance;
    private final String doc;
    @Nullable
    private final Object defaultValue;
    @Nullable
    private final ConfigDef.Validator validator;
    private final ConfigDef.Type type;
    private final String group;
    private final boolean isRequired;

    private ImmutableItem(String name, ConfigDef.Importance importance, String doc, @Nullable Object defaultValue, @Nullable ConfigDef.Validator validator, ConfigDef.Type type, String group, boolean isRequired) {
        this.name = name;
        this.importance = importance;
        this.doc = doc;
        this.defaultValue = defaultValue;
        this.validator = validator;
        this.type = type;
        this.group = group;
        this.isRequired = isRequired;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigDef.Importance getImportance() {
        return this.importance;
    }

    @Override
    public String getDoc() {
        return this.doc;
    }

    @Override
    @Nullable
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Nullable
    public ConfigDef.Validator getValidator() {
        return this.validator;
    }

    @Override
    public ConfigDef.Type getType() {
        return this.type;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    public final ImmutableItem withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableItem(newValue, this.importance, this.doc, this.defaultValue, this.validator, this.type, this.group, this.isRequired);
    }

    public final ImmutableItem withImportance(ConfigDef.Importance value) {
        if (this.importance == value) {
            return this;
        }
        ConfigDef.Importance newValue = Objects.requireNonNull(value, "importance");
        if (this.importance.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableItem(this.name, newValue, this.doc, this.defaultValue, this.validator, this.type, this.group, this.isRequired);
    }

    public final ImmutableItem withDoc(String value) {
        String newValue = Objects.requireNonNull(value, "doc");
        if (this.doc.equals(newValue)) {
            return this;
        }
        return new ImmutableItem(this.name, this.importance, newValue, this.defaultValue, this.validator, this.type, this.group, this.isRequired);
    }

    public final ImmutableItem withDefaultValue(@Nullable Object value) {
        if (this.defaultValue == value) {
            return this;
        }
        return new ImmutableItem(this.name, this.importance, this.doc, value, this.validator, this.type, this.group, this.isRequired);
    }

    public final ImmutableItem withValidator(@Nullable ConfigDef.Validator value) {
        if (this.validator == value) {
            return this;
        }
        return new ImmutableItem(this.name, this.importance, this.doc, this.defaultValue, value, this.type, this.group, this.isRequired);
    }

    public final ImmutableItem withType(ConfigDef.Type value) {
        if (this.type == value) {
            return this;
        }
        ConfigDef.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableItem(this.name, this.importance, this.doc, this.defaultValue, this.validator, newValue, this.group, this.isRequired);
    }

    public final ImmutableItem withGroup(String value) {
        String newValue = Objects.requireNonNull(value, "group");
        if (this.group.equals(newValue)) {
            return this;
        }
        return new ImmutableItem(this.name, this.importance, this.doc, this.defaultValue, this.validator, this.type, newValue, this.isRequired);
    }

    public final ImmutableItem withIsRequired(boolean value) {
        if (this.isRequired == value) {
            return this;
        }
        return new ImmutableItem(this.name, this.importance, this.doc, this.defaultValue, this.validator, this.type, this.group, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableItem && this.equalTo((ImmutableItem)another);
    }

    private boolean equalTo(ImmutableItem another) {
        return this.name.equals(another.name) && this.importance.equals((Object)another.importance) && this.doc.equals(another.doc) && Objects.equals(this.defaultValue, another.defaultValue) && Objects.equals(this.validator, another.validator) && this.type.equals((Object)another.type) && this.group.equals(another.group) && this.isRequired == another.isRequired;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.importance.hashCode();
        h2 += (h2 << 5) + this.doc.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.defaultValue);
        h2 += (h2 << 5) + Objects.hashCode(this.validator);
        h2 += (h2 << 5) + this.type.hashCode();
        h2 += (h2 << 5) + this.group.hashCode();
        h2 += (h2 << 5) + Booleans.hashCode(this.isRequired);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Item").omitNullValues().add("name", this.name).add("importance", this.importance).add("doc", this.doc).add("defaultValue", this.defaultValue).add("validator", this.validator).add("type", this.type).add("group", this.group).add("isRequired", this.isRequired).toString();
    }

    public static ImmutableItem copyOf(Plugin.Item instance) {
        if (instance instanceof ImmutableItem) {
            return (ImmutableItem)instance;
        }
        return ImmutableItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.Item", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_IMPORTANCE = 2L;
        private static final long INIT_BIT_DOC = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_GROUP = 16L;
        private static final long INIT_BIT_IS_REQUIRED = 32L;
        private long initBits = 63L;
        @Nullable
        private String name;
        @Nullable
        private ConfigDef.Importance importance;
        @Nullable
        private String doc;
        @Nullable
        private Object defaultValue;
        @Nullable
        private ConfigDef.Validator validator;
        @Nullable
        private ConfigDef.Type type;
        @Nullable
        private String group;
        private boolean isRequired;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Item instance) {
            ConfigDef.Validator validatorValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.importance(instance.getImportance());
            this.doc(instance.getDoc());
            Object defaultValueValue = instance.getDefaultValue();
            if (defaultValueValue != null) {
                this.defaultValue(defaultValueValue);
            }
            if ((validatorValue = instance.getValidator()) != null) {
                this.validator(validatorValue);
            }
            this.type(instance.getType());
            this.group(instance.getGroup());
            this.isRequired(instance.isRequired());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder importance(ConfigDef.Importance importance) {
            this.importance = Objects.requireNonNull(importance, "importance");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder doc(String doc) {
            this.doc = Objects.requireNonNull(doc, "doc");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultValue(@Nullable Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validator(@Nullable ConfigDef.Validator validator) {
            this.validator = validator;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(ConfigDef.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder group(String group) {
            this.group = Objects.requireNonNull(group, "group");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isRequired(boolean isRequired) {
            this.isRequired = isRequired;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableItem(this.name, this.importance, this.doc, this.defaultValue, this.validator, this.type, this.group, this.isRequired);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("importance");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("doc");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("group");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("isRequired");
            }
            return "Cannot build Item, some of required attributes are not set " + attributes;
        }
    }
}

