/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data.type;

import com.github.jcustenborder.kafka.connect.utils.data.type.TypeParser;
import org.apache.kafka.connect.data.Schema;
import shaded.com.fasterxml.jackson.databind.JsonNode;

public class Int16TypeParser
implements TypeParser {
    @Override
    public Object parseString(String s2, Schema schema) {
        return Short.parseShort(s2);
    }

    @Override
    public Class<?> expectedClass() {
        return Short.class;
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Object result;
        if (input.isNumber()) {
            result = input.shortValue();
        } else if (input.isTextual()) {
            result = this.parseString(input.textValue(), schema);
        } else {
            throw new UnsupportedOperationException(String.format("Could not parse '%s' to %s", input, this.expectedClass().getSimpleName()));
        }
        return result;
    }
}

